/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public enum ViewerSortOrder {
    MANUAL("manuell", 0, new ManualViewerComparator()),
    DEFAULT("standard", 1, new DefaultViewerComparator());

    final String label;
    final int val;
    final ViewerComparator vc;
    private static final int DESCENDING = 1;
    private static int direction;
    private static int propertyIdx;
    private static TimeTool time1;
    private static TimeTool time2;

    static {
        direction = 1;
        propertyIdx = 0;
        time1 = new TimeTool();
        time2 = new TimeTool();
    }

    private ViewerSortOrder(String label, int val, ViewerComparator vc) {
        this.label = label;
        this.val = val;
        this.vc = vc;
    }

    public int getDirection() {
        return direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == propertyIdx) {
            direction = 1 - direction;
        } else {
            propertyIdx = column;
            direction = 1;
        }
    }

    public static ViewerSortOrder getSortOrderPerValue(int i) {
        ViewerSortOrder[] viewerSortOrderArray = ViewerSortOrder.values();
        int n = viewerSortOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerSortOrder cvso = viewerSortOrderArray[n2];
            if (cvso.val == i) {
                return cvso;
            }
            ++n2;
        }
        return null;
    }

    public static class DefaultViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            MedicationTableViewerItem p1 = (MedicationTableViewerItem)e1;
            MedicationTableViewerItem p2 = (MedicationTableViewerItem)e2;
            int rc = 0;
            switch (propertyIdx) {
                case 0: {
                    EntryType et1 = p1.getEntryType();
                    EntryType et2 = p2.getEntryType();
                    rc = Integer.compare(et1.numericValue(), et2.numericValue());
                    break;
                }
                case 1: {
                    String l1 = p1.getArtikelLabel();
                    String l2 = p2.getArtikelLabel();
                    if (l1 == null) {
                        l1 = "";
                    }
                    if (l2 == null) {
                        l2 = "";
                    }
                    rc = l1.compareTo(l2);
                    break;
                }
                case 2: {
                    String dose1 = p1.getDosis();
                    String dose2 = p2.getDosis();
                    rc = dose1.compareTo(dose2);
                    break;
                }
                case 3: {
                    time1.set(p1.getBeginDate());
                    time2.set(p2.getBeginDate());
                    rc = time1.compareTo((Calendar)time2);
                    break;
                }
                case 4: {
                    String com1 = p1.getRemark();
                    String com2 = p2.getRemark();
                    rc = com1.compareTo(com2);
                    break;
                }
                case 5: {
                    boolean stop1IsValid = this.isStopped(p1.getEndDate());
                    boolean stop2IsValid = this.isStopped(p2.getEndDate());
                    if (stop1IsValid && stop2IsValid) {
                        time1.set(p1.getEndDate());
                        time2.set(p2.getEndDate());
                        rc = time1.compareTo((Calendar)time2);
                        break;
                    }
                    if (stop1IsValid && !stop2IsValid) {
                        rc = -1;
                        break;
                    }
                    if (!stop1IsValid && stop2IsValid) {
                        rc = 1;
                        break;
                    }
                    rc = 0;
                    break;
                }
                case 6: {
                    String stopReason2;
                    String stopReason1 = p1.getStopReason();
                    if (stopReason1 == null) {
                        stopReason1 = "";
                    }
                    if ((stopReason2 = p2.getStopReason()) == null) {
                        stopReason2 = "";
                    }
                    rc = stopReason1.compareTo(stopReason2);
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (direction == 1) {
                rc = -rc;
            }
            return rc;
        }

        private boolean isStopped(String endDate) {
            return endDate != null && endDate.length() > 4;
        }
    }

    public static class ManualViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            MedicationTableViewerItem p1 = (MedicationTableViewerItem)e1;
            MedicationTableViewerItem p2 = (MedicationTableViewerItem)e2;
            String sos1 = p1.getOrder();
            String sos2 = p2.getOrder();
            if (sos1.length() == 0 && sos2.length() == 0) {
                return 0;
            }
            int val1 = Integer.MAX_VALUE;
            int val2 = Integer.MAX_VALUE;
            try {
                val1 = Integer.parseInt(sos1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                val2 = Integer.parseInt(sos2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Integer.compare(val1, val2);
        }
    }
}

