/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class MedicationViewHelper {
    private static final int FILTER_PRESCRIPTION_AFTER_N_DAYS = 30;

    public static ViewerSortOrder getSelectedComparator() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("ch.elexis.core.ui.medication.ApplyCustomSorting");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        if (((Boolean)state.getValue()).booleanValue()) {
            return ViewerSortOrder.getSortOrderPerValue(ViewerSortOrder.MANUAL.val);
        }
        return ViewerSortOrder.getSortOrderPerValue(ViewerSortOrder.DEFAULT.val);
    }

    public static String calculateDailyCostAsString(List<Prescription> pres) {
        String TTCOST = Messages.FixMediDisplay_DailyCost;
        double cost = 0.0;
        boolean canCalculate = true;
        for (Prescription pr : pres) {
            float num = Prescription.calculateTagesDosis((String)pr.getDosis());
            try {
                Artikel art = pr.getArtikel();
                if (art != null) {
                    int ve = art.guessVE();
                    if (ve != 0) {
                        Money price = pr.getArtikel().getVKPreis();
                        cost += (double)num * price.getAmount() / (double)ve;
                        continue;
                    }
                    canCalculate = false;
                    continue;
                }
                canCalculate = false;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                canCalculate = false;
            }
        }
        double rounded = (double)Math.round(100.0 * cost) / 100.0;
        if (canCalculate) {
            return String.valueOf(TTCOST) + " " + Double.toString(rounded);
        }
        if (rounded == 0.0) {
            return String.valueOf(TTCOST) + " ?";
        }
        return String.valueOf(TTCOST) + " >" + Double.toString(rounded);
    }

    public static ArrayList<Artikel> getAllGtins(List<Prescription> pres) {
        ArrayList<Artikel> gtins = new ArrayList<Artikel>();
        for (Prescription pr : pres) {
            Artikel art = pr.getArtikel();
            if (art == null || gtins.contains(art)) continue;
            gtins.add(art);
        }
        return gtins;
    }

    public static List<Prescription> loadInputData(boolean loadFullHistory, String patId) {
        if (patId == null) {
            return Collections.emptyList();
        }
        if (loadFullHistory) {
            return MedicationViewHelper.loadAllHistorical(patId);
        }
        return MedicationViewHelper.loadNonHistorical(patId);
    }

    private static List<Prescription> loadNonHistorical(String patId) {
        List tmpPrescs = Patient.load((String)patId).getMedication(new EntryType[]{EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION});
        ArrayList<Prescription> result = new ArrayList<Prescription>();
        for (Prescription p : tmpPrescs) {
            if (p.getArtikel() != null && p.getArtikel().getATC_code() != null && p.getArtikel().getATC_code().toUpperCase().startsWith("J07")) continue;
            result.add(p);
        }
        return result;
    }

    private static List<Prescription> loadAllHistorical(String patId) {
        Query qbe = new Query(Prescription.class, null, null, "PATIENT_ARTIKEL_JOINT", new String[]{"DateFrom", "DateUntil", "RezeptID", "prescType", "Artikel"});
        qbe.add("PatientID", "=", patId);
        qbe.orderBy(true, new String[]{"DateFrom"});
        return qbe.execute();
    }
}

