/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.medication.views.MedicationComposite;
import ch.elexis.core.ui.medication.views.MedicationTableViewerContentProvider;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationViewerHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MedicationHistoryTableComposite
extends Composite {
    private TableViewer viewer;
    private TableColumnLayout layout;
    private MedicationComposite medicationComposite;
    private List<Prescription> pendingInput;

    public MedicationHistoryTableComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.layout = new TableColumnLayout();
        this.setLayout((Layout)this.layout);
        this.viewer = new TableViewer((Composite)this, 67586);
        this.viewer.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection is = (IStructuredSelection)MedicationHistoryTableComposite.this.viewer.getSelection();
                MedicationTableViewerItem presc = (MedicationTableViewerItem)is.getFirstElement();
                IPersistentObject po = presc != null ? presc.getLastDisposed() : null;
                MedicationHistoryTableComposite.this.medicationComposite.setLastDisposalPO(po);
                MedicationHistoryTableComposite.this.medicationComposite.setSelectedMedication(presc);
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)(presc != null ? presc.getPrescription() : null));
            }
        });
        MedicationViewerHelper.createTypeColumn(this.viewer, this.layout, 0);
        MedicationViewerHelper.createArticleColumn(this.viewer, this.layout, 1);
        MedicationViewerHelper.createDosageColumn(this.viewer, this.layout, 2);
        MedicationViewerHelper.createBeginColumn(this.viewer, this.layout, 3);
        MedicationViewerHelper.createIntakeCommentColumn(this.viewer, this.layout, 4);
        MedicationViewerHelper.createStopColumn(this.viewer, this.layout, 5);
        MedicationViewerHelper.createStopReasonColumn(this.viewer, this.layout, 6);
        MedicationViewerHelper.createMandantColumn(this.viewer, this.layout, 7);
        this.viewer.setContentProvider((IContentProvider)new MedicationTableViewerContentProvider((StructuredViewer)this.viewer));
    }

    public void setMedicationComposite(MedicationComposite medicationComposite) {
        this.medicationComposite = medicationComposite;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public void setInput(List<Prescription> medicationHistoryInput) {
        if (this.isVisible()) {
            this.viewer.setInput(medicationHistoryInput);
        } else {
            this.pendingInput = medicationHistoryInput;
        }
    }

    public void setPendingInput() {
        if (this.pendingInput != null) {
            this.viewer.setInput(this.pendingInput);
            this.pendingInput = null;
        }
    }
}

