/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.views.MedicationHistoryTableComposite;
import ch.elexis.core.ui.medication.views.MedicationTableComposite;
import ch.elexis.core.ui.medication.views.MedicationTableViewerContentProvider;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationViewHelper;
import ch.elexis.core.ui.medication.views.MedicationViewerHelper;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.core.ui.medication.views.provider.MedicationFilter;
import ch.elexis.core.ui.util.CreatePrescriptionHelper;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.views.controls.InteractionLink;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.TimeTool;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class MedicationComposite
extends Composite
implements ISelectionProvider,
ISelectionChangedListener {
    private Composite compositeSearchFilter;
    private Text txtSearch;
    private MedicationFilter medicationHistoryFilter;
    private GridData compositeSearchFilterLayoutData;
    private Composite compositeMedicationDetail;
    private Composite stackCompositeDosage;
    private Composite compositeDayTimeDosage;
    private Composite compositeFreeTextDosage;
    private StackLayout stackLayoutDosage;
    private Text txtMorning;
    private Text txtNoon;
    private Text txtEvening;
    private Text txtNight;
    private Text txtFreeText;
    private Composite tablesComposite;
    private StackLayout tablesLayout;
    private MedicationTableComposite medicationTableComposite;
    private MedicationHistoryTableComposite medicationHistoryTableComposite;
    private GridData compositeMedicationDetailLayoutData;
    private Button btnConfirm;
    private String[] signatureArray;
    private Button btnShowHistory;
    private StackLayout stackLayout;
    private Composite compositeMedicationTextDetails;
    private Composite compositeStopMedicationTextDetails;
    private Composite stackedMedicationDetailComposite;
    private WritableValue selectedMedication = new WritableValue(null, MedicationTableViewerItem.class);
    private WritableValue lastDisposalPO = new WritableValue(null, PersistentObject.class);
    private DateTime timeStopped;
    private DateTime dateStopped;
    private Button btnStopMedication;
    private Button btnToggleDetailComposite;
    private Label lblLastDisposalLink;
    private Label lblDailyTherapyCost;
    private Color tagBtnColor = UiDesk.getColor((String)"gruen");
    private Color stopBGColor = UiDesk.getColorFromRGB((String)"FF7256");
    private Color defaultBGColor = UiDesk.getColorFromRGB((String)"F0F0F0");
    private ControlDecoration ctrlDecor;
    private Patient pat;
    private PersistentObjectDropTarget dropTarget;
    private Text txtIntakeOrder;
    private Text txtDisposalComment;
    private Text txtStopComment;
    private MedicationTableViewerContentProvider.MedicationContentProviderComposite contentProviderComp;
    private InteractionLink interactionLink;
    private ListenerList selectionChangedListeners = new ListenerList();
    private Prescription dropChangePrescription;

    public MedicationComposite(Composite parent, int style, IWorkbenchPartSite partSite) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.searchFilterComposite();
        this.medicationTableComposite(partSite);
        this.stateComposite();
        this.medicationDetailComposite();
        this.showSearchFilterComposite(false);
        this.showMedicationDetailComposite(null);
        this.dropTarget = new PersistentObjectDropTarget("Medication", (Control)this, (PersistentObjectDropTarget.IReceiver)new DropMedicationReceiver(this.getShell()));
    }

    private void searchFilterComposite() {
        this.compositeSearchFilter = new Composite((Composite)this, 0);
        this.compositeSearchFilter.setLayout((Layout)new GridLayout(2, false));
        this.compositeSearchFilterLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.compositeSearchFilter.setLayoutData((Object)this.compositeSearchFilterLayoutData);
        ToolBar toolBar = new ToolBar(this.compositeSearchFilter, 256);
        ToolItem tiClear = new ToolItem(toolBar, 8);
        tiClear.setImage(Images.IMG_CLEAR.getImage());
        tiClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MedicationComposite.this.clearSearchFilter();
            }
        });
        this.txtSearch = new Text(this.compositeSearchFilter, 2048);
        this.txtSearch.setMessage(Messages.MedicationComposite_search);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                MedicationComposite.this.medicationHistoryFilter.setSearchText(MedicationComposite.this.txtSearch.getText());
            }
        });
    }

    private void clearSearchFilter() {
        this.txtSearch.setText("");
        this.medicationHistoryFilter.setSearchText("");
    }

    private void medicationTableComposite(IWorkbenchPartSite partSite) {
        this.tablesComposite = new Composite((Composite)this, 0);
        this.tablesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tablesLayout = new StackLayout();
        this.tablesComposite.setLayout((Layout)this.tablesLayout);
        this.medicationTableComposite = new MedicationTableComposite(this.tablesComposite, 0x10000000);
        this.medicationTableComposite.setMedicationComposite(this);
        MedicationViewerHelper.addContextMenu(this.medicationTableComposite.getTableViewer(), this, partSite);
        this.medicationTableComposite.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.medicationHistoryTableComposite = new MedicationHistoryTableComposite(this.tablesComposite, 0x10000000);
        this.medicationHistoryTableComposite.setMedicationComposite(this);
        MedicationViewerHelper.addContextMenu(this.medicationHistoryTableComposite.getTableViewer(), this, partSite);
        this.medicationHistoryTableComposite.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.medicationHistoryFilter = new MedicationFilter((Viewer)this.medicationHistoryTableComposite.getTableViewer());
        this.medicationHistoryTableComposite.getTableViewer().addFilter((ViewerFilter)this.medicationHistoryFilter);
        this.tablesLayout.topControl = this.medicationTableComposite;
    }

    public void setViewerSortOrder(ViewerSortOrder vso) {
        this.medicationTableComposite.getTableViewer().setComparator(vso.vc);
        this.medicationHistoryTableComposite.getTableViewer().setComparator(vso.vc);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("ch.elexis.core.ui.medication.ApplyCustomSorting");
        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)vso.equals((Object)ViewerSortOrder.MANUAL));
    }

    private void stateComposite() {
        Composite compositeState = new Composite((Composite)this, 0);
        GridLayout gl_compositeState = new GridLayout(6, false);
        gl_compositeState.marginWidth = 0;
        gl_compositeState.marginHeight = 0;
        gl_compositeState.horizontalSpacing = 0;
        compositeState.setLayout((Layout)gl_compositeState);
        compositeState.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.contentProviderComp = new MedicationTableViewerContentProvider.MedicationContentProviderComposite(compositeState, 0);
        this.contentProviderComp.setContentProvider((MedicationTableViewerContentProvider)this.medicationTableComposite.getTableViewer().getContentProvider());
        this.contentProviderComp.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLastDisposal = new Label(compositeState, 0);
        lblLastDisposal.setText(Messages.MedicationComposite_lastReceived);
        this.lblLastDisposalLink = new Label(compositeState, 0);
        this.lblLastDisposalLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PersistentObject po = (PersistentObject)MedicationComposite.this.lastDisposalPO.getValue();
                if (po == null) {
                    return;
                }
            }
        });
        this.lblLastDisposalLink.setForeground(UiDesk.getColor((String)"blau"));
        this.lblLastDisposalLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblDailyTherapyCost = new Label(compositeState, 0);
        this.lblDailyTherapyCost.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblDailyTherapyCost.setText(Messages.FixMediDisplay_DailyCost);
        this.interactionLink = new InteractionLink((Composite)this, 0);
        this.interactionLink.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnShowHistory = new Button(compositeState, 0x800002);
        this.btnShowHistory.setToolTipText(Messages.MedicationComposite_btnShowHistory_toolTipText);
        this.btnShowHistory.setText(Messages.MedicationComposite_btnCheckButton_text);
        this.btnShowHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MedicationComposite.this.btnShowHistory.getSelection()) {
                    MedicationComposite.this.showSearchFilterComposite(true);
                    ((MedicationComposite)MedicationComposite.this).tablesLayout.topControl = MedicationComposite.this.medicationHistoryTableComposite;
                    MedicationComposite.this.medicationHistoryTableComposite.setPendingInput();
                    MedicationComposite.this.medicationHistoryTableComposite.getTableViewer().refresh();
                    MedicationComposite.this.setViewerSortOrder(ViewerSortOrder.DEFAULT);
                    MedicationComposite.this.contentProviderComp.setContentProvider((MedicationTableViewerContentProvider)MedicationComposite.this.medicationHistoryTableComposite.getTableViewer().getContentProvider());
                } else {
                    MedicationComposite.this.showSearchFilterComposite(false);
                    ((MedicationComposite)MedicationComposite.this).tablesLayout.topControl = MedicationComposite.this.medicationTableComposite;
                    MedicationComposite.this.medicationTableComposite.setPendingInput();
                    MedicationComposite.this.medicationTableComposite.getTableViewer().refresh();
                    MedicationComposite.this.contentProviderComp.setContentProvider((MedicationTableViewerContentProvider)MedicationComposite.this.medicationTableComposite.getTableViewer().getContentProvider());
                }
                MedicationComposite.this.tablesComposite.layout();
                MedicationComposite.this.updateUi(MedicationComposite.this.pat, false);
            }
        });
        this.btnToggleDetailComposite = new Button(compositeState, 0x800002);
        this.btnToggleDetailComposite.setImage(Images.IMG_LOCK_CO.getImage());
        this.btnToggleDetailComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObj;
                if (MedicationComposite.this.btnToggleDetailComposite.getSelection() && (selectedObj = MedicationComposite.this.selectedMedication.getValue()) instanceof MedicationTableViewerItem) {
                    MedicationComposite.this.showMedicationDetailComposite((MedicationTableViewerItem)MedicationComposite.this.selectedMedication.getValue());
                }
            }
        });
    }

    public boolean isShowingHistory() {
        if (this.btnShowHistory != null && !this.btnShowHistory.isDisposed()) {
            return this.btnShowHistory.getSelection();
        }
        return false;
    }

    private void medicationDetailComposite() {
        this.compositeMedicationDetail = new Composite((Composite)this, 2048);
        GridLayout gl_compositeMedicationDetail = new GridLayout(6, false);
        gl_compositeMedicationDetail.marginBottom = 5;
        gl_compositeMedicationDetail.marginRight = 5;
        gl_compositeMedicationDetail.marginLeft = 5;
        gl_compositeMedicationDetail.marginTop = 5;
        gl_compositeMedicationDetail.marginWidth = 0;
        gl_compositeMedicationDetail.marginHeight = 0;
        this.compositeMedicationDetail.setLayout((Layout)gl_compositeMedicationDetail);
        this.compositeMedicationDetailLayoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.compositeMedicationDetail.setLayoutData((Object)this.compositeMedicationDetailLayoutData);
        this.stackCompositeDosage = new Composite(this.compositeMedicationDetail, 0);
        this.stackCompositeDosage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.stackLayoutDosage = new StackLayout();
        this.stackCompositeDosage.setLayout((Layout)this.stackLayoutDosage);
        this.compositeDayTimeDosage = new Composite(this.stackCompositeDosage, 0);
        this.compositeDayTimeDosage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout gl_compositeDayTimeDosage = new GridLayout(7, false);
        gl_compositeDayTimeDosage.marginWidth = 0;
        gl_compositeDayTimeDosage.marginHeight = 0;
        gl_compositeDayTimeDosage.verticalSpacing = 1;
        gl_compositeDayTimeDosage.horizontalSpacing = 0;
        this.compositeDayTimeDosage.setLayout((Layout)gl_compositeDayTimeDosage);
        this.txtMorning = new Text(this.compositeDayTimeDosage, 2048);
        this.txtMorning.setTextLimit(60);
        this.txtMorning.setMessage("morn");
        GridData gd_txtMorning = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtMorning.widthHint = 40;
        this.txtMorning.setLayoutData((Object)gd_txtMorning);
        this.txtMorning.addModifyListener((ModifyListener)new SignatureArrayModifyListener(0));
        Label lblStop = new Label(this.compositeDayTimeDosage, 256);
        lblStop.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStop.setText("-");
        this.txtNoon = new Text(this.compositeDayTimeDosage, 2048);
        this.txtNoon.setTextLimit(60);
        this.txtNoon.setMessage("noon");
        GridData gd_txtNoon = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtNoon.widthHint = 40;
        this.txtNoon.setLayoutData((Object)gd_txtNoon);
        this.txtNoon.addModifyListener((ModifyListener)new SignatureArrayModifyListener(1));
        Label lblStop2 = new Label(this.compositeDayTimeDosage, 0);
        lblStop2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStop2.setText("-");
        this.txtEvening = new Text(this.compositeDayTimeDosage, 2048);
        this.txtEvening.setTextLimit(60);
        this.txtEvening.setMessage("eve");
        GridData gd_txtEvening = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtEvening.widthHint = 40;
        this.txtEvening.setLayoutData((Object)gd_txtEvening);
        this.txtEvening.addModifyListener((ModifyListener)new SignatureArrayModifyListener(2));
        this.txtEvening.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        if (!MedicationComposite.this.btnConfirm.isEnabled()) break;
                        MedicationComposite.this.applyDetailChanges();
                        break;
                    }
                }
            }
        });
        Label lblStop3 = new Label(this.compositeDayTimeDosage, 0);
        lblStop3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStop3.setText("-");
        this.txtNight = new Text(this.compositeDayTimeDosage, 2048);
        this.txtNight.setTextLimit(60);
        this.txtNight.setMessage("night");
        GridData gd_txtNight = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtNight.widthHint = 40;
        this.txtNight.setLayoutData((Object)gd_txtNight);
        this.txtNight.addModifyListener((ModifyListener)new SignatureArrayModifyListener(3));
        this.txtNight.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        if (!MedicationComposite.this.btnConfirm.isEnabled()) break;
                        MedicationComposite.this.applyDetailChanges();
                        break;
                    }
                }
            }
        });
        this.compositeFreeTextDosage = new Composite(this.stackCompositeDosage, 0);
        this.compositeFreeTextDosage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout gl_compositeFreeTextDosage = new GridLayout(1, false);
        gl_compositeFreeTextDosage.marginWidth = 0;
        gl_compositeFreeTextDosage.marginHeight = 0;
        gl_compositeFreeTextDosage.verticalSpacing = 1;
        gl_compositeFreeTextDosage.horizontalSpacing = 0;
        this.compositeFreeTextDosage.setLayout((Layout)gl_compositeFreeTextDosage);
        this.txtFreeText = new Text(this.compositeFreeTextDosage, 2048);
        this.txtFreeText.setMessage(Messages.MedicationComposite_freetext);
        GridData gd_txtFreeText = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtFreeText.widthHint = 210;
        this.txtFreeText.setLayoutData((Object)gd_txtFreeText);
        this.txtFreeText.setTextLimit(255);
        this.txtFreeText.addModifyListener((ModifyListener)new SignatureArrayModifyListener(0));
        this.txtFreeText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        if (!MedicationComposite.this.btnConfirm.isEnabled()) break;
                        MedicationComposite.this.applyDetailChanges();
                        break;
                    }
                }
            }
        });
        this.stackLayoutDosage.topControl = this.compositeDayTimeDosage;
        this.stackCompositeDosage.layout();
        Button btnDoseSwitch = new Button(this.compositeMedicationDetail, 8);
        btnDoseSwitch.setImage(Images.IMG_SYNC.getImage());
        btnDoseSwitch.setToolTipText(Messages.MedicationComposite_tooltipDosageType);
        btnDoseSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((MedicationComposite)MedicationComposite.this).stackLayoutDosage.topControl = ((MedicationComposite)MedicationComposite.this).stackLayoutDosage.topControl == MedicationComposite.this.compositeDayTimeDosage ? MedicationComposite.this.compositeFreeTextDosage : MedicationComposite.this.compositeDayTimeDosage;
                MedicationComposite.this.stackCompositeDosage.layout();
            }
        });
        this.timeStopped = new DateTime(this.compositeMedicationDetail, 128);
        this.timeStopped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MedicationComposite.this.activateConfirmButton(true);
            }
        });
        this.dateStopped = new DateTime(this.compositeMedicationDetail, 32);
        this.dateStopped.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MedicationComposite.this.activateConfirmButton(true);
            }
        });
        DataBindingContext dbc = new DataBindingContext();
        IObservableValue dateTimeStopObservable = PojoProperties.value((String)"endTime", Date.class).observeDetail((IObservableValue)this.selectedMedication);
        ISWTObservableValue timeObservable = WidgetProperties.selection().observe((Widget)this.timeStopped);
        ISWTObservableValue dateObservable = WidgetProperties.selection().observe((Widget)this.dateStopped);
        dbc.bindValue((IObservableValue)new DateAndTimeObservableValue((IObservableValue)dateObservable, (IObservableValue)timeObservable), dateTimeStopObservable);
        this.btnStopMedication = new Button(this.compositeMedicationDetail, 0x800002);
        this.btnStopMedication.setImage(Images.IMG_STOP.getImage());
        this.btnStopMedication.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnStopMedication.setToolTipText(Messages.MedicationComposite_btnStop);
        this.btnStopMedication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MedicationComposite.this.btnStopMedication.getSelection()) {
                    ((MedicationComposite)MedicationComposite.this).stackLayout.topControl = MedicationComposite.this.compositeStopMedicationTextDetails;
                    MedicationComposite.this.compositeMedicationDetail.setBackground(MedicationComposite.this.stopBGColor);
                    MedicationComposite.this.compositeStopMedicationTextDetails.setBackground(MedicationComposite.this.stopBGColor);
                    MedicationComposite.this.dateStopped.setEnabled(true);
                    MedicationComposite.this.timeStopped.setEnabled(true);
                    MedicationComposite.this.activateConfirmButton(true);
                } else {
                    MedicationComposite.this.compositeMedicationDetail.setBackground(MedicationComposite.this.defaultBGColor);
                    MedicationComposite.this.compositeStopMedicationTextDetails.setBackground(MedicationComposite.this.defaultBGColor);
                    ((MedicationComposite)MedicationComposite.this).stackLayout.topControl = MedicationComposite.this.compositeMedicationTextDetails;
                    MedicationComposite.this.dateStopped.setEnabled(false);
                    MedicationComposite.this.timeStopped.setEnabled(false);
                    MedicationComposite.this.activateConfirmButton(false);
                }
                MedicationComposite.this.stackedMedicationDetailComposite.layout();
            }
        });
        this.btnConfirm = new Button(this.compositeMedicationDetail, 0x800000);
        this.btnConfirm.setText(Messages.MedicationComposite_btnConfirm);
        GridData gdBtnConfirm = new GridData();
        gdBtnConfirm.horizontalIndent = 5;
        gdBtnConfirm.horizontalAlignment = 131072;
        this.btnConfirm.setLayoutData((Object)gdBtnConfirm);
        this.btnConfirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MedicationComposite.this.applyDetailChanges();
            }
        });
        this.btnConfirm.setEnabled(false);
        this.stackedMedicationDetailComposite = new Composite(this.compositeMedicationDetail, 0);
        this.stackedMedicationDetailComposite.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        this.stackLayout = new StackLayout();
        this.stackedMedicationDetailComposite.setLayout((Layout)this.stackLayout);
        this.compositeMedicationTextDetails = new Composite(this.stackedMedicationDetailComposite, 0);
        GridLayout gl_compositeMedicationTextDetails = new GridLayout(1, false);
        gl_compositeMedicationTextDetails.marginWidth = 0;
        gl_compositeMedicationTextDetails.horizontalSpacing = 0;
        gl_compositeMedicationTextDetails.marginHeight = 0;
        this.compositeMedicationTextDetails.setLayout((Layout)gl_compositeMedicationTextDetails);
        this.compositeMedicationTextDetails.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        this.txtIntakeOrder = new Text(this.compositeMedicationTextDetails, 2048);
        this.txtIntakeOrder.setMessage(Messages.MedicationComposite_txtIntakeOrder_message);
        this.txtIntakeOrder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ISWTObservableValue txtIntakeOrderObservable = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.txtIntakeOrder);
        IObservableValue intakeOrderObservable = PojoProperties.value((String)"remark", String.class).observeDetail((IObservableValue)this.selectedMedication);
        dbc.bindValue((IObservableValue)txtIntakeOrderObservable, intakeOrderObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        txtIntakeOrderObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                MedicationComposite.this.activateConfirmButton(true);
            }
        });
        this.txtDisposalComment = new Text(this.compositeMedicationTextDetails, 2048);
        this.txtDisposalComment.setMessage(Messages.MedicationComposite_txtComment_message);
        this.txtDisposalComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ISWTObservableValue txtCommentObservable = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.txtDisposalComment);
        IObservableValue commentObservable = PojoProperties.value((String)"disposalComment", String.class).observeDetail((IObservableValue)this.selectedMedication);
        dbc.bindValue((IObservableValue)txtCommentObservable, commentObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        txtCommentObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                MedicationComposite.this.activateConfirmButton(true);
            }
        });
        this.stackLayout.topControl = this.compositeMedicationTextDetails;
        this.compositeStopMedicationTextDetails = new Composite(this.stackedMedicationDetailComposite, 0);
        GridLayout gl_compositeStopMedicationTextDetails = new GridLayout(1, false);
        gl_compositeStopMedicationTextDetails.marginWidth = 0;
        gl_compositeStopMedicationTextDetails.horizontalSpacing = 0;
        gl_compositeStopMedicationTextDetails.marginHeight = 0;
        this.compositeStopMedicationTextDetails.setLayout((Layout)gl_compositeStopMedicationTextDetails);
        this.compositeStopMedicationTextDetails.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        this.txtStopComment = new Text(this.compositeStopMedicationTextDetails, 2048);
        this.txtStopComment.setMessage(Messages.MedicationComposite_stopReason);
        this.txtStopComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ISWTObservableValue txtStopCommentObservableUi = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.txtStopComment);
        IObservableValue txtStopCommentObservable = PojoProperties.value((String)"stopReason", String.class).observeDetail((IObservableValue)this.selectedMedication);
        dbc.bindValue((IObservableValue)txtStopCommentObservableUi, txtStopCommentObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        txtStopCommentObservableUi.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                MedicationComposite.this.activateConfirmButton(true);
            }
        });
    }

    private void applyDetailChanges() {
        final MedicationTableViewerItem pres = (MedicationTableViewerItem)this.selectedMedication.getValue();
        if (pres == null) {
            return;
        }
        AcquireLockUi.aquireAndRun((IPersistentObject)pres.getPrescription(), (ILockHandler)new ILockHandler(){

            public void lockFailed() {
            }

            public void lockAcquired() {
                Prescription oldPrescription = pres.getPrescription();
                String endDate = pres.getEndDate();
                if (!MedicationComposite.this.btnStopMedication.getSelection()) {
                    Prescription newPrescription = new Prescription(oldPrescription);
                    newPrescription.setDosis(MedicationComposite.this.getDosisStringFromSignatureTextArray());
                    newPrescription.setBemerkung(MedicationComposite.this.txtIntakeOrder.getText());
                    newPrescription.setDisposalComment(MedicationComposite.this.txtDisposalComment.getText());
                }
                if (MedicationComposite.this.btnStopMedication.getSelection()) {
                    TimeTool endTime = new TimeTool(pres.getEndTime());
                    oldPrescription.stop(endTime);
                } else {
                    oldPrescription.stop(null);
                }
                if (endDate != null && !endDate.isEmpty()) {
                    Prescription newStoppedPrescription = new Prescription(oldPrescription);
                    newStoppedPrescription.setBeginDate(oldPrescription.getBeginTime());
                    TimeTool ttEndDate = new TimeTool(pres.getEndTime());
                    newStoppedPrescription.stop(ttEndDate);
                    newStoppedPrescription.setStopReason("\u00c4nderung des Stop Datums von " + endDate);
                    oldPrescription.stop(null);
                } else if (MedicationComposite.this.txtStopComment.getText() == null || MedicationComposite.this.txtStopComment.getText().isEmpty()) {
                    oldPrescription.setStopReason("Ge\u00e4ndert durch " + CoreHub.actUser.getLabel());
                } else {
                    oldPrescription.setStopReason(MedicationComposite.this.txtStopComment.getText());
                }
            }
        });
        this.activateConfirmButton(false);
        if (this.btnStopMedication.isEnabled()) {
            this.showMedicationDetailComposite(null);
        }
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)pres.getPrescription(), Prescription.class, 4)});
    }

    public void showMedicationDetailComposite(MedicationTableViewerItem presc) {
        if (presc == null && this.btnToggleDetailComposite != null && this.btnToggleDetailComposite.getSelection()) {
            return;
        }
        boolean showDetailComposite = presc != null;
        this.compositeMedicationDetail.setVisible(showDetailComposite);
        boolean bl = this.compositeMedicationDetailLayoutData.exclude = !showDetailComposite;
        if (showDetailComposite && presc != null) {
            boolean stopped = presc.getEndDate().length() > 1;
            this.stackLayout.topControl = stopped ? this.compositeStopMedicationTextDetails : this.compositeMedicationTextDetails;
            this.txtEvening.setEnabled(!stopped);
            this.txtMorning.setEnabled(!stopped);
            this.txtNight.setEnabled(!stopped);
            this.txtNoon.setEnabled(!stopped);
            this.txtIntakeOrder.setEnabled(!stopped);
            this.txtDisposalComment.setEnabled(!stopped);
            this.txtStopComment.setEnabled(!stopped);
            this.txtFreeText.setEnabled(!stopped);
            this.dateStopped.setEnabled(false);
            this.timeStopped.setEnabled(false);
            this.btnStopMedication.setEnabled(presc.isFixedMediation());
            this.stackedMedicationDetailComposite.layout();
            this.compositeMedicationDetail.setBackground(this.defaultBGColor);
            this.compositeStopMedicationTextDetails.setBackground(this.defaultBGColor);
            this.btnStopMedication.setSelection(false);
        }
        this.layout(true);
    }

    private void showSearchFilterComposite(boolean show) {
        this.medicationHistoryFilter.setSearchText("");
        this.compositeSearchFilterLayoutData.exclude = !show;
        this.compositeSearchFilter.setVisible(show);
        this.layout(true);
    }

    protected void checkSubclass() {
    }

    public void updateUi(Patient pat, boolean forceUpdate) {
        if (this.pat == pat && !forceUpdate) {
            return;
        }
        this.pat = pat;
        this.clearSearchFilter();
        this.lastDisposalPO.setValue(null);
        if (pat == null) {
            return;
        }
        List<Prescription> medicationInput = MedicationViewHelper.loadInputData(false, pat.getId());
        this.medicationTableComposite.setInput(medicationInput);
        List<Prescription> medicationHistoryInput = MedicationViewHelper.loadInputData(true, pat.getId());
        this.medicationHistoryTableComposite.setInput(medicationHistoryInput);
        this.contentProviderComp.refresh();
        this.selectedMedication.setValue(null);
        this.lblLastDisposalLink.setText("");
        this.showMedicationDetailComposite(null);
        if (medicationInput != null) {
            String dailyCost = MedicationViewHelper.calculateDailyCostAsString(medicationInput);
            this.lblDailyTherapyCost.setText(dailyCost);
            this.interactionLink.updateAtcs(MedicationViewHelper.getAllGtins(medicationInput));
        } else {
            this.lblDailyTherapyCost.setText("");
            this.interactionLink.updateAtcs(new ArrayList());
        }
    }

    public boolean setFocus() {
        if (this.medicationTableComposite != null && this.medicationTableComposite.isVisible()) {
            this.medicationTableComposite.setPendingInput();
        }
        if (this.medicationHistoryTableComposite != null && this.medicationHistoryTableComposite.isVisible()) {
            this.medicationHistoryTableComposite.setPendingInput();
        }
        return super.setFocus();
    }

    private void setValuesForTextSignature(String[] signatureArray) {
        boolean isFreetext;
        boolean bl = isFreetext = !signatureArray[0].isEmpty() && signatureArray[1].isEmpty() && signatureArray[2].isEmpty() && signatureArray[3].isEmpty();
        if (isFreetext) {
            this.txtFreeText.setText(signatureArray[0]);
            this.txtMorning.setText("");
            this.txtNoon.setText("");
            this.txtEvening.setText("");
            this.txtNight.setText("");
            if (this.stackLayoutDosage.topControl == this.compositeDayTimeDosage) {
                this.stackLayoutDosage.topControl = this.compositeFreeTextDosage;
                this.stackCompositeDosage.layout();
            }
        } else {
            this.txtFreeText.setText("");
            this.txtMorning.setText(signatureArray[0]);
            this.txtNoon.setText(signatureArray[1]);
            this.txtEvening.setText(signatureArray[2]);
            this.txtNight.setText(signatureArray[3]);
            if (this.stackLayoutDosage.topControl == this.compositeFreeTextDosage) {
                this.stackLayoutDosage.topControl = this.compositeDayTimeDosage;
                this.stackCompositeDosage.layout();
            }
        }
    }

    private String getDosisStringFromSignatureTextArray() {
        if (this.stackLayoutDosage.topControl == this.compositeDayTimeDosage) {
            String[] values = new String[]{this.txtMorning.getText().isEmpty() ? "0" : this.txtMorning.getText(), this.txtNoon.getText().isEmpty() ? "0" : this.txtNoon.getText(), this.txtEvening.getText().isEmpty() ? "0" : this.txtEvening.getText(), this.txtNight.getText().isEmpty() ? "0" : this.txtNight.getText()};
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < values.length) {
                String string = values[i];
                if (string.length() > 0) {
                    if (i > 0) {
                        sb.append("-");
                    }
                    sb.append(string);
                }
                ++i;
            }
            return sb.toString();
        }
        return this.txtFreeText.getText();
    }

    private void activateConfirmButton(boolean activate) {
        MedicationTableViewerItem pres;
        if (this.ctrlDecor == null) {
            this.initControlDecoration();
        }
        if ((pres = (MedicationTableViewerItem)this.selectedMedication.getValue()) != null) {
            pres.isStopped();
        }
        if (activate) {
            this.btnConfirm.setBackground(this.tagBtnColor);
            this.btnConfirm.setEnabled(true);
            this.ctrlDecor.show();
        } else {
            this.btnConfirm.setBackground(this.defaultBGColor);
            this.btnConfirm.setEnabled(false);
            this.ctrlDecor.hide();
        }
    }

    private void initControlDecoration() {
        this.ctrlDecor = new ControlDecoration((Control)this.btnConfirm, 128);
        this.ctrlDecor.setDescriptionText(Messages.MedicationComposite_decorConfirm);
        Image imgWarn = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.ctrlDecor.setImage(imgWarn);
    }

    public void resetSelectedMedication() {
        this.selectedMedication.setValue(null);
    }

    public void setLastDisposalPO(IPersistentObject po) {
        this.lastDisposalPO.setValue((Object)po);
        if (po != null) {
            String label = "";
            if (po instanceof Rezept) {
                Rezept rp = (Rezept)po;
                label = MessageFormat.format(Messages.MedicationComposite_recipeFrom, rp.getDate());
            } else if (po instanceof Verrechnet) {
                Verrechnet v = (Verrechnet)po;
                label = v.getKons() == null ? Messages.MedicationComposite_consMissing : MessageFormat.format(Messages.MedicationComposite_consFrom, v.getKons().getDatum());
            }
            this.lblLastDisposalLink.setText(label);
        } else {
            this.lblLastDisposalLink.setText("");
        }
    }

    public void setSelectedMedication(MedicationTableViewerItem presc) {
        this.selectedMedication.setValue((Object)presc);
        this.showMedicationDetailComposite(presc);
        this.signatureArray = Prescription.getSignatureAsStringArray((String)(presc != null ? presc.getDosis() : null));
        this.setValuesForTextSignature(this.signatureArray);
    }

    public void refresh() {
        this.medicationTableComposite.getTableViewer().refresh();
        this.medicationHistoryTableComposite.getTableViewer().refresh();
    }

    public TableViewer getActiveTableViewer() {
        Control topControl = this.tablesLayout.topControl;
        if (topControl instanceof MedicationTableComposite) {
            return ((MedicationTableComposite)topControl).getTableViewer();
        }
        if (topControl instanceof MedicationHistoryTableComposite) {
            return ((MedicationHistoryTableComposite)topControl).getTableViewer();
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.tablesLayout.topControl instanceof MedicationTableComposite) {
            return ((MedicationTableComposite)this.tablesLayout.topControl).getTableViewer().getSelection();
        }
        if (this.tablesLayout.topControl instanceof MedicationHistoryTableComposite) {
            return ((MedicationHistoryTableComposite)this.tablesLayout.topControl).getTableViewer().getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.tablesLayout.topControl instanceof MedicationTableComposite) {
            ((MedicationTableComposite)this.tablesLayout.topControl).getTableViewer().setSelection(selection);
        } else if (this.tablesLayout.topControl instanceof MedicationHistoryTableComposite) {
            ((MedicationHistoryTableComposite)this.tablesLayout.topControl).getTableViewer().setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    public ICodeSelectorTarget getDropTarget() {
        return this.dropTarget;
    }

    public void setDropChangePrescription(Prescription changePrescription) {
        this.dropChangePrescription = changePrescription;
    }

    private final class DropMedicationReceiver
    implements PersistentObjectDropTarget.IReceiver {
        private Shell parentShell;

        public DropMedicationReceiver(Shell parentShell) {
            this.parentShell = parentShell;
        }

        public void dropped(final PersistentObject article, DropTargetEvent ev) {
            if (this.isVaccination(article)) {
                MessageDialog.openWarning((Shell)this.parentShell, (String)Messages.MedicationComposite_isVaccinationTitle, (String)Messages.MedicationComposite_isVaccinationText);
                return;
            }
            if (MedicationComposite.this.dropChangePrescription == null) {
                CreatePrescriptionHelper prescriptionHelper = new CreatePrescriptionHelper((Artikel)article, this.parentShell);
                prescriptionHelper.createPrescription();
            } else {
                final Prescription changedPrescription = new Prescription(MedicationComposite.this.dropChangePrescription);
                AcquireLockUi.aquireAndRun((IPersistentObject)changedPrescription, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                        changedPrescription.remove();
                    }

                    public void lockAcquired() {
                        changedPrescription.set("Artikel", article.storeToString());
                        MedicationComposite.this.dropChangePrescription.stop(null);
                        MedicationComposite.this.dropChangePrescription.setStopReason("Ersetzt durch " + ((Artikel)article).getName());
                    }
                });
                MedicationComposite.this.dropChangePrescription = null;
            }
            MedicationComposite.this.refresh();
        }

        private boolean isVaccination(PersistentObject article) {
            return ((Artikel)article).getATC_code().startsWith("J07");
        }

        public boolean accept(PersistentObject o) {
            if (!(o instanceof Artikel)) {
                return false;
            }
            return !this.isVaccination((PersistentObject)((Artikel)o));
        }
    }

    private class SignatureArrayModifyListener
    implements ModifyListener {
        final int index;

        public SignatureArrayModifyListener(int index) {
            this.index = index;
        }

        public void modifyText(ModifyEvent e) {
            String text = ((Text)e.getSource()).getText();
            MedicationComposite.this.activateConfirmButton(!MedicationComposite.this.signatureArray[this.index].equals(text));
        }
    }
}

