/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.data.Prescription;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class SetAsFixMedicationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MedicationTableViewerItem mtvItem;
        Prescription presc;
        IStructuredSelection strucSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && (firstElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) instanceof MedicationTableViewerItem && (presc = (mtvItem = (MedicationTableViewerItem)firstElement).getPrescription()) != null && presc.getEntryType() != EntryType.FIXED_MEDICATION) {
            AcquireLockUi.aquireAndRun((IPersistentObject)presc, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    final Prescription reserveMedi = new Prescription(presc);
                    AcquireLockUi.aquireAndRun((IPersistentObject)reserveMedi, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                            reserveMedi.remove();
                        }

                        public void lockAcquired() {
                            reserveMedi.setEntryType(EntryType.FIXED_MEDICATION);
                        }
                    });
                    presc.stop(null);
                    presc.setStopReason("Umgestellt auf Fix Medikation");
                }
            });
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)presc, Prescription.class, 4)});
        }
        return null;
    }
}

