/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationView;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.core.ui.views.RezeptBlatt;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTakingsListHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "ch.elexis.core.ui.medication.PrintTakingsList";
    private static Logger log = LoggerFactory.getLogger(PrintTakingsListHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Prescription> prescRecipes;
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            return null;
        }
        String medicationType = event.getParameter("ch.elexis.core.ui.medication.commandParameter.medication");
        if (medicationType == null || medicationType.isEmpty()) {
            medicationType = "selection";
        }
        if (!(prescRecipes = this.getPrescriptions(patient, medicationType, event)).isEmpty()) {
            prescRecipes = this.sortPrescriptions(prescRecipes, event);
            try {
                RezeptBlatt rpb = (RezeptBlatt)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.RezeptBlatt");
                rpb.createEinnahmeliste(patient, prescRecipes.toArray(new Prescription[prescRecipes.size()]));
            }
            catch (PartInitException e) {
                log.error("Error outputting recipe", (Throwable)e);
            }
        }
        return null;
    }

    private List<Prescription> sortPrescriptions(List<Prescription> prescRecipes, ExecutionEvent event) {
        SorterAdapter sorter = new SorterAdapter(event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof MedicationView) {
            return sorter.getSorted(prescRecipes);
        }
        return prescRecipes;
    }

    private List<Prescription> getPrescriptions(Patient patient, String medicationType, ExecutionEvent event) {
        if ("selection".equals(medicationType)) {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection != null && !selection.isEmpty()) {
                ArrayList<Prescription> ret = new ArrayList<Prescription>();
                IStructuredSelection strucSelection = (IStructuredSelection)selection;
                if (strucSelection.getFirstElement() instanceof MedicationTableViewerItem) {
                    List mtvItems = strucSelection.toList();
                    for (MedicationTableViewerItem mtvItem : mtvItems) {
                        Prescription p = mtvItem.getPrescription();
                        if (p == null) continue;
                        ret.add(p);
                    }
                } else if (strucSelection.getFirstElement() instanceof Prescription) {
                    ret.addAll(strucSelection.toList());
                }
                return ret;
            }
        } else {
            if ("all".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION});
            }
            if ("fix".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
            }
            if ("reserve".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.RESERVE_MEDICATION});
            }
        }
        return Collections.emptyList();
    }

    public static class SorterAdapter {
        private ViewerSortOrder.ManualViewerComparator manualComparator = new ViewerSortOrder.ManualViewerComparator();
        private ViewerSortOrder.DefaultViewerComparator defaultComparator = new ViewerSortOrder.DefaultViewerComparator();
        private CompareMode mode = CompareMode.DEFAULT;

        public SorterAdapter(ExecutionEvent event) {
            Command command;
            State state;
            ICommandService commandService = (ICommandService)HandlerUtil.getActiveSite((ExecutionEvent)event).getService(ICommandService.class);
            if (commandService != null && (state = (command = commandService.getCommand("ch.elexis.core.ui.medication.ApplyCustomSorting")).getState("org.eclipse.ui.commands.toggleState")).getValue() instanceof Boolean && ((Boolean)state.getValue()).booleanValue()) {
                this.mode = CompareMode.MANUAL;
            }
        }

        public List<Prescription> getSorted(List<Prescription> list) {
            Object[] toSort;
            Object[] objectArray = toSort = MedicationTableViewerItem.createFromPrescriptionList(list, null).toArray(new MedicationTableViewerItem[list.size()]);
            int n = toSort.length;
            int n2 = 0;
            while (n2 < n) {
                MedicationTableViewerItem medicationTableViewerItem = objectArray[n2];
                medicationTableViewerItem.resolve();
                ++n2;
            }
            if (this.mode == CompareMode.DEFAULT) {
                this.defaultComparator.sort(null, toSort);
            } else if (this.mode == CompareMode.MANUAL) {
                this.manualComparator.sort(null, toSort);
            }
            ArrayList<Prescription> ret = new ArrayList<Prescription>();
            int i = 0;
            while (i < toSort.length) {
                ret.add(((MedicationTableViewerItem)toSort[i]).getPrescription());
                ++i;
            }
            return ret;
        }

        private static enum CompareMode {
            MANUAL,
            DEFAULT;

        }
    }
}

