/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.views.BestellView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddArticleToOrderHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(AddArticleToOrderHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        List<Artikel> articlesToOrder = this.getArticlesToOrder(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection());
        if (articlesToOrder.isEmpty()) {
            log.debug("Skip handler execution as no articles are selected to add to an order!");
            return null;
        }
        try {
            BestellView bestellView = (BestellView)activePage.showView("ch.elexis.BestellenView");
            if (bestellView != null) {
                bestellView.addItemsToOrder(articlesToOrder);
            } else {
                log.error("Cant't load BestellView to add articles to order");
            }
        }
        catch (PartInitException e) {
            log.error("Cant't load BestellView to add articles to order", (Throwable)e);
        }
        return null;
    }

    private List<Artikel> getArticlesToOrder(ISelection selection) {
        ArrayList<Artikel> articlesToOrder = new ArrayList<Artikel>();
        if (selection == null || selection.isEmpty()) {
            return articlesToOrder;
        }
        IStructuredSelection structSelcection = (IStructuredSelection)selection;
        List mtvItems = structSelcection.toList();
        for (MedicationTableViewerItem mtvItem : mtvItems) {
            Artikel arti;
            Prescription p = mtvItem.getPrescription();
            if (p == null || (arti = p.getArtikel()) == null) continue;
            articlesToOrder.add(arti);
        }
        return articlesToOrder;
    }
}

