/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.actions;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.types.PathologicDescription;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.LabResult;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;

public class LaborResultSetNonPathologicAction
extends Action {
    private List<LabResult> results;
    private StructuredViewer viewer;

    public LaborResultSetNonPathologicAction(List<LabResult> results, StructuredViewer viewer) {
        super(Messages.SetNonPathologic);
        this.results = results;
        this.viewer = viewer;
    }

    public void run() {
        for (final LabResult result : this.results) {
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)result, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    result.setFlag(1, false);
                    result.setPathologicDescription(new PathologicDescription(PathologicDescription.Description.PATHO_MANUAL));
                }
            });
        }
        this.viewer.refresh();
    }

    public boolean isEnabled() {
        for (LabResult result : this.results) {
            if (result.getItem().getTyp() != LabItemTyp.DOCUMENT) continue;
            return false;
        }
        return super.isEnabled();
    }

    public boolean isChecked() {
        for (LabResult result : this.results) {
            if (!result.isFlag(1)) continue;
            return true;
        }
        return false;
    }
}

