/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers.multifile.strategy;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.OverwriteAllImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.importers.multifile.strategy.FileImportStrategyUtil;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.core.ui.importer.div.importers.LabImportUtil;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.io.FileTool;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPDFImportStrategy
implements IFileImportStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultPDFImportStrategy.class);
    private static final String PDF = "pdf";
    private IDocumentManager docManager;
    private IContact myLab;
    private String labName;
    private IPatient patient;
    private TimeTool dateTime;
    private String group;
    private String prio;
    private LabImportUtil labImportUtil = new LabImportUtil();
    private boolean testMode = false;
    private boolean moveAfterImport;
    private String pdfImportCategory;

    public DefaultPDFImportStrategy() {
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os != null) {
            this.docManager = (IDocumentManager)os;
        }
    }

    public Result<Object> execute(File file, Map<String, Object> context, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        try {
            this.initValuesFromContext(context);
            if (this.docManager == null) {
                if (this.moveAfterImport) {
                    FileImportStrategyUtil.moveAfterImport((boolean)false, (File)file);
                }
                return new Result(Result.SEVERITY.ERROR, 2, MessageFormat.format(Messages.DefaultPDFImportStrategy_NoDocManager, file.getName(), this.patient.getLabel()), (Object)this.patient.getId(), true);
            }
        }
        catch (IllegalStateException ise) {
            if (this.moveAfterImport) {
                FileImportStrategyUtil.moveAfterImport((boolean)false, (File)file);
            }
            return new Result(Result.SEVERITY.ERROR, 2, String.valueOf(Messages.DefaultPDFImportStrategy_InitContextFailed) + "\n" + ise.getMessage(), context, true);
        }
        String name = "Dokument";
        String shortname = "doc";
        LabItem labItem = this.getLabItem(shortname, name, LabItemTyp.DOCUMENT);
        if (labItem == null) {
            labItem = this.labImportUtil.createLabItem(shortname, name, this.myLab, "", "", PDF, LabItemTyp.DOCUMENT, this.group, this.prio);
            log.debug("LabItem created [{}]", (Object)labItem);
        }
        String titel = this.generatePDFTitle(file.getName(), this.dateTime);
        String orderId = "noorder";
        Object importHandler = this.testMode ? new OverwriteAllImportHandler() : new DefaultLabImportUiHandler();
        try {
            String category;
            String string = category = StringUtils.isNotBlank((String)this.pdfImportCategory) ? this.pdfImportCategory : this.labName;
            if (this.addDocument(titel, category, this.dateTime.toString(4), file, file.getName())) {
                TransientLabResult importResult = new TransientLabResult.Builder(this.patient, this.myLab, (ILabItem)labItem, titel).date(this.dateTime).build((ILabImportUtil)this.labImportUtil);
                orderId = this.labImportUtil.importLabResults(Collections.singletonList(importResult), (ImportHandler)importHandler);
            } else {
                log.warn("pdf [{}] already present in document manager (omnivore), replacing", (Object)file.getAbsolutePath());
                Patient pat = Patient.load((String)this.patient.getId());
                List documentList = this.docManager.listDocuments(pat, category, titel, null, new TimeSpan(String.valueOf(this.dateTime.toString(4)) + "-" + this.dateTime.toString(4)), null);
                documentList.forEach(iop -> this.docManager.removeDocument(iop.getGUID()));
                this.docManager.addDocument((IOpaqueDocument)new GenericDocument(pat, titel, category, file, this.dateTime.toString(4), file.getName(), FileTool.getExtension((String)file.getName())));
            }
        }
        catch (ElexisException | IOException e) {
            log.error("error saving pdf [" + file.getAbsolutePath() + "] in document manager (omnivore)");
        }
        if (this.moveAfterImport) {
            FileImportStrategyUtil.moveAfterImport((boolean)true, (File)file);
        }
        return new Result(Result.SEVERITY.OK, 0, "OK", (Object)orderId, false);
    }

    private void initValuesFromContext(Map<String, Object> context) {
        String msg;
        StringBuilder sbFailed = new StringBuilder();
        this.patient = (IPatient)context.get("patient");
        if (this.patient == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Patient);
            sbFailed.append("; ");
        }
        this.myLab = new ContactBean((Kontakt)Labor.load((String)((String)context.get("labid"))));
        if (this.myLab == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Lab);
            sbFailed.append("; ");
        }
        if (CoreHub.localCfg.get("hl7Parser/importencdata", false)) {
            this.labName = CoreHub.localCfg.get("hl7Parser/importencdataCategory", null);
        }
        if (this.labName == null || this.labName.isEmpty()) {
            this.labName = (String)context.get("labname");
            if (this.labName == null) {
                sbFailed.append(Messages.DefaultPDFImportStrategy_LabName);
                sbFailed.append("; ");
            }
        }
        this.dateTime = (TimeTool)context.get("time");
        if (this.dateTime == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Date);
            sbFailed.append("; ");
        }
        this.group = (String)context.get("group");
        if (this.group == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Group);
            sbFailed.append("; ");
        }
        this.prio = (String)context.get("prio");
        if (this.prio == null) {
            sbFailed.append(Messages.DefaultPDFImportStrategy_Prio);
            sbFailed.append("; ");
        }
        if ((msg = sbFailed.toString()) != null && !msg.isEmpty()) {
            throw new IllegalStateException(msg);
        }
    }

    private LabItem getLabItem(String shortname, String name, LabItemTyp type) {
        Query qbe = new Query(LabItem.class);
        qbe.add("kuerzel", "=", shortname);
        qbe.add("LaborID", "=", this.myLab.getId());
        qbe.add("Typ", "=", new Integer(type.ordinal()).toString());
        LabItem labItem = null;
        List itemList = qbe.execute();
        if (itemList.size() > 0) {
            labItem = (LabItem)itemList.get(0);
        }
        return labItem;
    }

    private String generatePDFTitle(String filename, TimeTool dateTime) {
        SimpleDateFormat sdfTitle = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String title = "Laborbefund" + sdfTitle.format(dateTime.getTime()) + "." + FileTool.getExtension((String)filename);
        log.debug("generated labresult pdf title '" + title);
        return title;
    }

    private boolean addDocument(String title, String category, String dateStr, File file, String keywords) throws IOException, ElexisException {
        this.findOrCreateCategory(category);
        Patient pat = Patient.load((String)this.patient.getId());
        List documentList = this.docManager.listDocuments(pat, category, title, null, new TimeSpan(String.valueOf(dateStr) + "-" + dateStr), null);
        if (documentList == null || documentList.size() == 0) {
            this.docManager.addDocument((IOpaqueDocument)new GenericDocument(pat, title, category, file, dateStr, keywords, FileTool.getExtension((String)file.getName())));
            return true;
        }
        return false;
    }

    private void findOrCreateCategory(String category) {
        if (category != null) {
            String[] categories;
            boolean exists = false;
            String[] stringArray = categories = this.docManager.getCategories();
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (category.equals(cat)) {
                    exists = true;
                }
                ++n2;
            }
            if (!exists) {
                if (this.docManager.addCategorie(category)) {
                    log.info("Created category " + category + " for multi file import");
                } else {
                    log.warn("Could not create category " + category + " for multi file import");
                }
            }
        }
    }

    public void setTestMode(boolean testing) {
        this.testMode = testing;
    }

    public IFileImportStrategy setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }

    public IFileImportStrategy setLabContactResolver(ILabContactResolver resolver) {
        return this;
    }

    public DefaultPDFImportStrategy setPDFImportCategory(String category) {
        this.pdfImportCategory = category;
        return this;
    }
}

