/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers.multifile.strategy;

import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.multifile.strategy.BasicFileImportStrategyFactory;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.elexis.core.ui.importer.div.importers.multifile.strategy.DefaultPDFImportStrategy;
import ch.rgw.io.FileTool;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultImportStrategyFactory
extends BasicFileImportStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultImportStrategyFactory.class);
    private boolean moveAfterImport;
    private ILabContactResolver labContactResolver;
    private String pdfImportCategory;

    public Map<File, IFileImportStrategy> createImportStrategyMap(File hl7File) {
        Map ret = super.createImportStrategyMap(hl7File);
        List matchingFiles = this.getMatchingFiles(hl7File);
        if (!matchingFiles.isEmpty()) {
            DefaultPDFImportStrategy pdfImportStrategy = new DefaultPDFImportStrategy();
            if (this.pdfImportCategory != null) {
                pdfImportStrategy.setPDFImportCategory(this.pdfImportCategory);
            }
            for (File mFile : matchingFiles) {
                String type = FileTool.getExtension((String)mFile.getName()).toLowerCase();
                if (!"pdf".equals(type)) continue;
                log.debug("... adding [" + mFile.getName() + "] with DefaultPDFImportStrategy");
                ret.put(mFile, pdfImportStrategy);
            }
        }
        ret.values().forEach(strategy -> {
            IFileImportStrategy iFileImportStrategy = strategy.setMoveAfterImport(this.moveAfterImport).setLabContactResolver(this.labContactResolver);
        });
        return ret;
    }

    public IFileImportStrategyFactory setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }

    public IFileImportStrategyFactory setPDFImportCategory(String category) {
        this.pdfImportCategory = category;
        return this;
    }

    public IFileImportStrategyFactory setLabContactResolver(ILabContactResolver resolver) {
        this.labContactResolver = resolver;
        return this;
    }
}

