/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.ILabImportUtil;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.core.ui.text.GenericDocument;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.rgw.tools.TimeTool;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabImportUtil
implements ILabImportUtil {
    private static Logger logger = LoggerFactory.getLogger(LabImportUtil.class);

    public static Labor getOrCreateLabor(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Labor identifier [" + identifier + "] invalid.");
        }
        Labor labor = null;
        Query qbe = new Query(Labor.class);
        qbe.startGroup();
        qbe.add("Kuerzel", "LIKE", "%" + identifier + "%");
        qbe.or();
        qbe.add("Bezeichnung1", "LIKE", "%" + identifier + "%");
        qbe.endGroup();
        List results = qbe.execute();
        if (results.isEmpty()) {
            labor = new Labor(identifier, "Labor " + identifier);
            logger.warn("Found no Labor for identifier [" + identifier + "]. Created new Labor contact.");
        } else {
            labor = (Labor)results.get(0);
            if (results.size() > 1) {
                logger.warn("Found more than one Labor for identifier [" + identifier + "]. This can cause problems when importing results.");
            }
        }
        return labor;
    }

    public static Labor getLinkLabor(String identifier) {
        KontaktSelektor ks;
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Labor identifier [" + identifier + "] invalid.");
        }
        Labor labor = null;
        Kontakt k = (Kontakt)Xid.findObject((String)"www.elexis.ch/xid/kontakt/lab/sendingfacility", (String)identifier);
        if (k != null) {
            labor = Labor.load((String)k.getId());
        }
        if (labor == null && (ks = new KontaktSelektor(UiDesk.getTopShell(), Labor.class, Messages.LabImporterUtil_Select, String.valueOf(Messages.LabImporterUtil_SelectLab) + " [" + identifier + "]", Kontakt.DEFAULT_SORT)).open() == 0) {
            labor = (Labor)ks.getSelection();
            labor.addXid("www.elexis.ch/xid/kontakt/lab/sendingfacility", identifier, true);
        }
        return labor;
    }

    public static LabItem getLabItem(String identifier, Labor labor) {
        LabMapping mapping = LabMapping.getByContactAndItemName((String)labor.getId(), (String)identifier);
        if (mapping != null) {
            return mapping.getLabItem();
        }
        LabItem labItem = null;
        Query qbe = new Query(LabItem.class);
        qbe.add("LaborID", "=", labor.getId());
        qbe.add("kuerzel", "=", identifier);
        List list = qbe.execute();
        if (!list.isEmpty()) {
            labItem = (LabItem)list.get(0);
            if (list.size() > 1) {
                logger.warn("Found more than one LabItem for identifier [" + identifier + "] and Labor [" + labor.getLabel(true) + "]. This can cause problems when importing results.");
            }
        }
        return labItem;
    }

    public static List<LabResult> getLabResults(IPatient patient, ILabItem item, TimeTool date, TimeTool analyseTime, TimeTool observationTime) {
        if (date == null && analyseTime == null && observationTime == null) {
            throw new IllegalArgumentException("No timestamp specified.");
        }
        Query qr = new Query(LabResult.class);
        qr.add("PatientID", "=", patient.getId());
        qr.add("ItemID", "=", item.getId());
        if (date != null) {
            qr.add("Datum", "=", date.toString(4));
        }
        if (analyseTime != null) {
            qr.add("analysetime", "=", analyseTime.toString(13));
        }
        if (observationTime != null) {
            qr.add("observationtime", "=", observationTime.toString(13));
        }
        return qr.execute();
    }

    public String importLabResults(List<TransientLabResult> results, ImportHandler uiHandler) {
        List orders;
        List<LabResult> existing;
        boolean overWriteAll = false;
        String mandantId = this.findMandantIdForLabResults(results);
        String orderId = LabOrder.getNextOrderId();
        boolean newResult = false;
        for (TransientLabResult transientLabResult : results) {
            List<LabResult> existing2 = LabImportUtil.getExistingResults(transientLabResult);
            if (existing2.isEmpty()) {
                ILabResult iLabResult = this.createLabResult(transientLabResult, orderId, mandantId);
                newResult = true;
                CoreHub.getLocalLockService().acquireLock((IPersistentObject)((LabResult)iLabResult));
                CoreHub.getLocalLockService().releaseLock((IPersistentObject)((LabResult)iLabResult));
                continue;
            }
            for (LabResult labResult : existing2) {
                if (overWriteAll) {
                    CoreHub.getLocalLockService().acquireLock((IPersistentObject)labResult);
                    transientLabResult.overwriteExisting((ILabResult)labResult);
                    CoreHub.getLocalLockService().releaseLock((IPersistentObject)labResult);
                    continue;
                }
                if (transientLabResult.isSameResult((ILabResult)labResult)) {
                    logger.info("Result " + labResult.toString() + " already exists.");
                    continue;
                }
                ImportHandler.OverwriteState retVal = uiHandler.askOverwrite(transientLabResult.getPatient(), (ILabResult)labResult, transientLabResult);
                if (retVal == ImportHandler.OverwriteState.OVERWRITE) {
                    CoreHub.getLocalLockService().acquireLock((IPersistentObject)labResult);
                    transientLabResult.overwriteExisting((ILabResult)labResult);
                    CoreHub.getLocalLockService().releaseLock((IPersistentObject)labResult);
                    continue;
                }
                if (retVal == ImportHandler.OverwriteState.OVERWRITEALL) {
                    overWriteAll = true;
                    CoreHub.getLocalLockService().acquireLock((IPersistentObject)labResult);
                    transientLabResult.overwriteExisting((ILabResult)labResult);
                    CoreHub.getLocalLockService().releaseLock((IPersistentObject)labResult);
                    continue;
                }
                logger.info("Will not overwrite labResult [" + labResult.getId() + "] due to user decision.");
            }
        }
        if (!(newResult || results.isEmpty() || (existing = LabImportUtil.getExistingResults(results.get(0))).isEmpty() || (orders = LabOrder.getLabOrders((String)existing.get(0).getPatient().getId(), null, null, (LabResult)existing.get(0), null, null, null)).isEmpty())) {
            orderId = ((LabOrder)orders.get(0)).get("orderid");
        }
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, LabResult.class, 8)});
        return orderId;
    }

    private String findMandantIdForLabResults(List<TransientLabResult> results) {
        Mandant mandant;
        if (results != null && !results.isEmpty()) {
            Mandant mandant2;
            Konsultation konsultation;
            Patient patient;
            IPatient iPatient;
            TransientLabResult transientLabResult = results.get(0);
            OrcMessage orcMessage = transientLabResult.getOrcMessage();
            if (orcMessage != null && !orcMessage.getNames().isEmpty()) {
                for (String name : orcMessage.getNames()) {
                    String id;
                    String[] splitNames = name.split(" ");
                    int size = splitNames.length;
                    if (size <= 1) continue;
                    Query qbe = new Query(Mandant.class);
                    qbe.startGroup();
                    qbe.add("Bezeichnung1", "LIKE", splitNames[0], true);
                    qbe.and();
                    qbe.add("Bezeichnung2", "LIKE", splitNames[1], true);
                    qbe.endGroup();
                    qbe.or();
                    qbe.startGroup();
                    qbe.add("Bezeichnung1", "LIKE", splitNames[1], true);
                    qbe.and();
                    qbe.add("Bezeichnung2", "LIKE", splitNames[0], true);
                    qbe.endGroup();
                    List list = qbe.execute();
                    if (list.size() != 1 || (id = ((Mandant)list.get(0)).getId()) == null) continue;
                    logger.debug("labimport - mandantor [" + id + "] found with orc name db match");
                    return id;
                }
                logger.warn("labimport - " + orcMessage.getNames().toString() + " not found or not unique in db - try to find mandantor via last konsultation");
            }
            if ((iPatient = transientLabResult.getPatient()) != null && (patient = Patient.load((String)iPatient.getId())).exists() && (konsultation = patient.getLastKonsultation()) != null && konsultation.exists() && (mandant2 = konsultation.getMandant()) != null && mandant2.getId() != null) {
                logger.debug("labimport - mandantor found [" + mandant2.getId() + "] with last konsultation");
                return mandant2.getId();
            }
        }
        if ((mandant = ElexisEventDispatcher.getSelectedMandator()) != null) {
            logger.debug("labimport - use the active selected mandantor [" + mandant.getId() + "]");
            return mandant.getId();
        }
        throw new RuntimeException("No selected mandantor found!");
    }

    private static List<LabResult> getExistingResults(TransientLabResult transientLabResult) {
        List<LabResult> ret = Collections.emptyList();
        if (!transientLabResult.getLabItem().getTyp().equals((Object)LabItemTyp.DOCUMENT)) {
            ret = transientLabResult.isObservationTime() ? LabImportUtil.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), null, null, transientLabResult.getObservationTime()) : (transientLabResult.isAnalyseTime() ? LabImportUtil.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), null, transientLabResult.getAnalyseTime(), null) : LabImportUtil.getLabResults(transientLabResult.getPatient(), transientLabResult.getLabItem(), transientLabResult.getDate(), null, null));
            if (transientLabResult.getSubId() != null) {
                Iterator<LabResult> it = ret.iterator();
                while (it.hasNext()) {
                    LabResult result = it.next();
                    String subId = result.getDetail("Hl7SubId");
                    if (subId == null || transientLabResult.getSubId().equals(subId)) continue;
                    it.remove();
                }
            }
        }
        return ret;
    }

    @Deprecated
    public ILabResult createLabResult(TransientLabResult transientLabResult, String orderId) {
        return this.createLabResult(transientLabResult, orderId, CoreHub.actMandant.getId());
    }

    public ILabResult createLabResult(TransientLabResult transientLabResult, String orderId, String mandantId) {
        ILabResult labResult = null;
        List existing = LabOrder.getLabOrders((String)transientLabResult.getPatient().getId(), null, (ILabItem)transientLabResult.getLabItem(), null, null, null, (LabOrder.State)LabOrder.State.ORDERED);
        LabOrder labOrder = null;
        if (existing == null || existing.isEmpty()) {
            TimeTool time = transientLabResult.getObservationTime();
            if (time == null) {
                time = transientLabResult.getDate();
            }
            labResult = transientLabResult.persist(null, orderId, mandantId, time, "Import");
            labOrder = (LabOrder)labResult.getLabOrder();
        } else {
            labOrder = (LabOrder)existing.get(0);
            labResult = transientLabResult.persist((ILabOrder)labOrder, null, null, null, null);
        }
        labOrder.setState(LabOrder.State.DONE_IMPORT);
        return labResult;
    }

    public ILabItem getLabItem(String identifier, IContact labor) {
        LabMapping mapping = LabMapping.getByContactAndItemName((String)labor.getId(), (String)identifier);
        if (mapping != null) {
            return mapping.getLabItem();
        }
        LabItem labItem = null;
        Query qbe = new Query(LabItem.class);
        qbe.add("LaborID", "=", labor.getId());
        qbe.add("kuerzel", "=", identifier);
        List list = qbe.execute();
        if (!list.isEmpty()) {
            labItem = (LabItem)list.get(0);
            if (list.size() > 1) {
                logger.warn("Found more than one LabItem for identifier [" + identifier + "] and Labor [" + labor.getLabel() + "]. This can cause problems when importing results.");
            }
        }
        return labItem;
    }

    public ILabItem createLabItem(String code, String name, IContact labor, String male, String female, String unit, LabItemTyp typ, String testGroupName, String nextTestGroupSequence) {
        return new LabItem(code, name, labor.getId(), male, female, unit, typ, testGroupName, nextTestGroupSequence);
    }

    public ILabItem getDocumentLabItem(String shortname, String name, IContact labor) {
        Query qbe = new Query(LabItem.class);
        qbe.add("kuerzel", "=", shortname);
        qbe.add("LaborID", "=", labor.getId());
        qbe.add("Typ", "=", new Integer(LabItemTyp.DOCUMENT.ordinal()).toString());
        LabItem labItem = null;
        List itemList = qbe.execute();
        if (itemList.size() > 0) {
            labItem = (LabItem)itemList.get(0);
        }
        return labItem;
    }

    public void createCommentsLabResult(TextData hl7TextData, IPatient pat, IContact labor, int number, TimeTool commentDate) {
        if (hl7TextData.getDate() == null) {
            hl7TextData.setDate(commentDate.getTime());
        }
        TimeTool commentsDate = new TimeTool(hl7TextData.getDate());
        Query qbe = new Query(LabItem.class);
        qbe.add("LaborID", "=", labor.getId());
        qbe.add("titel", "=", "Kommentar");
        qbe.add("kuerzel", "=", "kommentar");
        List list = qbe.execute();
        LabItem li = null;
        if (list.size() < 1) {
            LabItemTyp typ = LabItemTyp.TEXT;
            li = new LabItem("kommentar", "Kommentar", labor.getId(), "", "", "", typ, "00 Kommentar", Integer.toString(number));
        } else {
            li = (LabItem)list.get(0);
        }
        Query qr = new Query(LabResult.class);
        qr.add("PatientID", "=", pat.getId());
        qr.add("Datum", "=", commentsDate.toString(4));
        qr.add("ItemID", "=", li.getId());
        if (qr.execute().size() == 0) {
            StringBuilder comment = new StringBuilder();
            if (hl7TextData.getText() != null) {
                comment.append(hl7TextData.getText());
            }
            if (hl7TextData.getComment() != null) {
                comment.append(hl7TextData.getComment());
            }
            LabResult labResult = new LabResult(pat, commentsDate, (ILabItem)li, "text", comment.toString(), labor);
            labResult.setObservationTime(commentsDate);
            CoreHub.getLocalLockService().acquireLock((IPersistentObject)labResult);
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)labResult);
        }
    }

    public void createDocumentManagerEntry(String title, String lab, byte[] data, String mimeType, TimeTool date, IPatient pat) {
        Object os = Extensions.findBestService((String)"DocumentManagement");
        if (os != null) {
            IDocumentManager docManager = (IDocumentManager)os;
            boolean catIsNotExisting = true;
            String[] stringArray = docManager.getCategories();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cat = stringArray[n2];
                if (cat.equals(lab)) {
                    catIsNotExisting = false;
                    break;
                }
                ++n2;
            }
            if (catIsNotExisting) {
                docManager.addCategorie(lab);
            }
            try {
                Patient patient = Patient.load((String)pat.getId());
                docManager.addDocument((IOpaqueDocument)new GenericDocument(patient, title, lab, data, date.toString(4), null, mimeType));
            }
            catch (ElexisException | IOException e) {
                logger.error("Error saving document received via hl7 in local document manager", e);
            }
        }
    }

    public ILabResult createLabResult(IPatient patient, TimeTool date, ILabItem labItem, String result, String comment, String refVal, IContact origin, String subId, ILabOrder labOrder, String orderId, String mandantId, TimeTool time, String groupName) {
        Patient pat = Patient.load((String)patient.getId());
        LabItem item = LabItem.load((String)labItem.getId());
        Labor labor = Labor.load((String)origin.getId());
        logger.debug("Creating result with patient [" + pat.getId() + "] labitem [" + item.getId() + "] origin [" + labor.getId() + "]");
        LabResult labResult = LabResult.createLabResultAndAssertLabOrder((Patient)pat, (TimeTool)date, (LabItem)item, (String)result, (String)comment, (Labor)labor, (String)refVal, (ILabOrder)labOrder, (String)orderId, (String)mandantId, (TimeTool)time, (String)groupName);
        if (subId != null) {
            labResult.setDetail("Hl7SubId", subId);
        }
        return labResult;
    }

    public void updateLabResult(ILabResult iLabResult, TransientLabResult transientLabResult) {
        if (iLabResult != null) {
            ((LabResult)iLabResult).setDetail("Hl7SubId", transientLabResult.getSubId());
        }
    }
}

