/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.rgw.tools.JdbcLink;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class AccessWrapper {
    private Database db;
    private static String ImportPrefix = "";

    public AccessWrapper(File mdbFile) throws IOException {
        new DatabaseBuilder().setReadOnly(true);
        this.db = DatabaseBuilder.open((File)mdbFile);
    }

    public AccessWrapper(File mdbFile, Charset ch) throws IOException {
        new DatabaseBuilder().setReadOnly(true).setCharset(ch);
        this.db = DatabaseBuilder.open((File)mdbFile);
    }

    public void setPrefixForImportedTableNames(String prefix) {
        ImportPrefix = prefix;
    }

    public int convertTable(String name, JdbcLink dest) throws IOException, SQLException {
        Table table = this.db.getTable(name);
        String insertName = String.valueOf(ImportPrefix) + name;
        List cols = table.getColumns();
        try {
            dest.exec("DROP TABLE IF EXISTS " + insertName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(insertName).append("(");
        for (Column c : cols) {
            sb.append(c.getName()).append(" ");
            switch (c.getType()) {
                case MEMO: {
                    sb.append("TEXT");
                    break;
                }
                case INT: 
                case LONG: {
                    sb.append("INTEGER");
                    break;
                }
                case TEXT: {
                    sb.append("VARCHAR(255)");
                    break;
                }
                default: {
                    sb.append("VARCHAR(255)");
                }
            }
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(");");
        dest.exec(sb.toString());
        Row row = null;
        int nrRows = 0;
        while ((row = table.getNextRow()) != null) {
            ++nrRows;
            StringBuilder left = new StringBuilder();
            left.append("INSERT INTO ").append(insertName).append("(");
            StringBuilder right = new StringBuilder();
            right.append(" VALUES(");
            for (String key : row.keySet()) {
                left.append(key).append(",");
                right.append("?,");
            }
            left.deleteCharAt(left.length() - 1);
            right.deleteCharAt(right.length() - 1);
            left.append(") ").append((CharSequence)right).append(");");
            PreparedStatement ps = dest.prepareStatement(left.toString());
            int i = 1;
            for (String key : row.keySet()) {
                ps.setObject(i++, row.get(key));
            }
            ps.execute();
            ps.close();
        }
        return nrRows;
    }

    public Database getDatabase() {
        return this.db;
    }
}

