/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigendiagnosen;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.eigendiagnosen.Messages;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Eigendiagnose;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class Importer
extends ImporterPage {
    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fbi = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fbi.setFilter(new String[]{"*.csv", "*.xls", "*"}, new String[]{Messages.Eigendiagnosen_csvDescription, Messages.Eigendiagnosen_msExcelDescription, Messages.Eigendiagnosen_allFilesDescription});
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return fbi;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        Result<String> res;
        File file = new File(this.results[0]);
        if (!file.canRead()) {
            this.log.log(String.valueOf(Messages.Eigendiagnosen_CantRead) + this.results[0], 2);
            return new Status(4, "ch.elexis.base.codeextension.eigendiagnosen", String.valueOf(Messages.Eigendiagnosen_CantRead) + this.results[0]);
        }
        if (this.results[0].endsWith(".xls")) {
            res = this.importExcel(file.getAbsolutePath(), monitor);
        } else if (this.results[0].endsWith(".csv")) {
            res = this.importCSV(file.getAbsolutePath(), monitor);
        } else {
            return new Status(4, "ch.elexis.base.codeextension.eigendiagnosen", Messages.Eigendiagnosen_UnsupportedFileFormat);
        }
        res.isOK();
        return ResultAdapter.getResultAsStatus(res);
    }

    public String getDescription() {
        return Messages.Eigendiagnosen_ImportFromCsvAndExcel;
    }

    public String getTitle() {
        return Messages.Eigendiagnosen_CodeSystemName;
    }

    private Result<String> importExcel(String file, IProgressMonitor mon) {
        ExcelWrapper xl = new ExcelWrapper();
        if (!xl.load(file, 0)) {
            return new Result(Result.SEVERITY.ERROR, 1, Messages.Eigendiagnosen_BadFileFormat, (Object)file, true);
        }
        int i = xl.getFirstRow();
        while (i <= xl.getLastRow()) {
            List row = xl.getRow(i);
            this.importLine(row.toArray(new String[0]));
            ++i;
        }
        return new Result((Object)"OK");
    }

    private Result<String> importCSV(String file, IProgressMonitor mon) {
        try {
            String[] line;
            CSVReader cr = new CSVReader((Reader)new FileReader(file));
            while ((line = cr.readNext()) != null) {
                this.importLine(line);
            }
            return new Result((Object)"OK");
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Result(Result.SEVERITY.ERROR, 1, String.valueOf(Messages.Eigendiagnosen_CantRead) + file, (Object)ex.getMessage(), true);
        }
    }

    private void importLine(String[] line) {
        Query qbe = new Query(Eigendiagnose.class);
        qbe.add("Kuerzel", "=", line[1]);
        List f = qbe.execute();
        if (f != null && f.size() > 0) {
            Eigendiagnose ed = (Eigendiagnose)f.get(0);
            ed.set(new String[]{"parent", "Kuerzel", "Text", "Kommentar"}, new String[]{line[0], line[1], line[2], line[3]});
        } else {
            new Eigendiagnose(line[0], line[1], line[2], line[3]);
        }
    }
}

