/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.eigenartikel.Eigenartikel;
import ch.elexis.core.eigenartikel.acl.ACLContributor;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.eigenartikel.EigenartikelComposite;
import ch.elexis.core.ui.eigenartikel.EigenartikelProductComposite;
import ch.elexis.core.ui.eigenartikel.Messages;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.data.PersistentObject;
import java.text.MessageFormat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewSite;

public class EigenartikelDetailDisplay
implements IDetailDisplay {
    private IViewSite site;
    private EigenartikelProductComposite epc;
    private EigenartikelComposite ec;
    private Eigenartikel selectedObject;
    private Eigenartikel currentLock;
    private StackLayout layout;
    private Composite container;
    private Composite compProduct;
    private Composite compArticle;
    private RestrictedAction createAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY, ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_newAction){
        {
            this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            this.setToolTipText(ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_createProductToolTipText);
        }

        public void doRun() {
            Eigenartikel ea = new Eigenartikel("New Product", "");
            ElexisEventDispatcher.reload(Eigenartikel.class);
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)ea);
        }
    };
    private RestrictedAction toggleLockAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY, "lock", 2){
        {
            this.setImageDescriptor(Images.IMG_LOCK_CLOSED.getImageDescriptor());
        }

        public void setChecked(boolean checked) {
            if (checked) {
                this.setImageDescriptor(Images.IMG_LOCK_OPEN.getImageDescriptor());
            } else {
                this.setImageDescriptor(Images.IMG_LOCK_CLOSED.getImageDescriptor());
            }
            super.setChecked(checked);
        }

        public void doRun() {
            if (EigenartikelDetailDisplay.this.selectedObject != null) {
                if (CoreHub.getLocalLockService().isLocked((IPersistentObject)EigenartikelDetailDisplay.this.selectedObject)) {
                    CoreHub.getLocalLockService().releaseLock((IPersistentObject)EigenartikelDetailDisplay.this.selectedObject);
                    ElexisEventDispatcher.reload(Eigenartikel.class);
                    EigenartikelDetailDisplay.this.currentLock = null;
                } else {
                    LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)EigenartikelDetailDisplay.this.selectedObject);
                    if (lr.isOk()) {
                        EigenartikelDetailDisplay.this.currentLock = EigenartikelDetailDisplay.this.selectedObject;
                    } else {
                        LockResponseHelper.showInfo((LockResponse)lr, (IPersistentObject)EigenartikelDetailDisplay.this.selectedObject, null);
                    }
                }
            }
            this.setChecked(CoreHub.getLocalLockService().isLocked((IPersistentObject)EigenartikelDetailDisplay.this.currentLock));
        }
    };
    private RestrictedAction deleteAction = new LockRequestingRestrictedAction<Eigenartikel>(ACLContributor.EIGENARTIKEL_MODIFY, ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_deleteAction){
        {
            this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            this.setToolTipText(ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_deleteProductToolTipText);
        }

        public Eigenartikel getTargetedObject() {
            return (Eigenartikel)ElexisEventDispatcher.getSelected(Eigenartikel.class);
        }

        public void doRun(Eigenartikel act) {
            if (MessageDialog.openConfirm((Shell)EigenartikelDetailDisplay.this.site.getShell(), (String)ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_deleteActionConfirmCaption, (String)MessageFormat.format(ch.elexis.core.ui.views.artikel.Messages.ArtikelContextMenu_deleteConfirmBody, act.getName()))) {
                act.delete();
                if (EigenartikelDetailDisplay.this.epc != null) {
                    EigenartikelDetailDisplay.this.epc.setProductEigenartikel(null);
                }
            }
            ElexisEventDispatcher.reload(Eigenartikel.class);
        }
    };
    private ElexisEventListener eeli_egartikel = new ElexisUiEventListenerImpl(Eigenartikel.class){

        public void runInUi(ElexisEvent ev) {
            Eigenartikel egArtikel = (Eigenartikel)ev.getObject();
            switch (ev.getType()) {
                case 4096: 
                case 16384: {
                    if (egArtikel != null && EigenartikelDetailDisplay.this.selectedObject != null && egArtikel.getId().equals(EigenartikelDetailDisplay.this.selectedObject.getId()) && ev.getType() == 4096) {
                        EigenartikelDetailDisplay.this.epc.setUnlocked(true);
                        break;
                    }
                    EigenartikelDetailDisplay.this.epc.setUnlocked(false);
                    break;
                }
            }
        }
    };

    public Composite createDisplay(Composite parent, IViewSite site) {
        this.site = site;
        this.container = new Composite(parent, 0);
        parent.setLayoutData((Object)new GridData(1808));
        this.layout = new StackLayout();
        this.container.setLayout((Layout)this.layout);
        this.compProduct = new Composite(this.container, 0);
        this.compProduct.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(this.compProduct, 0x820800);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        ToolBarManager manager = new ToolBarManager(toolBar);
        manager.add((IAction)this.createAction);
        if (CoreHub.getLocalLockService().getStatus() != ILocalLockService.Status.STANDALONE) {
            manager.add((IAction)this.toggleLockAction);
        }
        manager.add((IAction)this.deleteAction);
        manager.update(true);
        toolBar.pack();
        this.epc = new EigenartikelProductComposite(this.compProduct, 0);
        this.epc.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.epc.setUnlocked(CoreHub.getLocalLockService().getStatus() == ILocalLockService.Status.STANDALONE);
        if (CoreHub.getLocalLockService().getStatus() != ILocalLockService.Status.STANDALONE) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_egartikel});
        }
        this.compArticle = new Composite(this.container, 0);
        this.compArticle.setLayout((Layout)new GridLayout(1, false));
        this.ec = new EigenartikelComposite(this.compArticle, 0, false, null);
        this.ec.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.ec.setUnlocked(false);
        this.layout.topControl = this.compProduct;
        this.container.layout();
        return this.container;
    }

    public Class<? extends PersistentObject> getElementClass() {
        return Eigenartikel.class;
    }

    public void display(Object obj) {
        this.toggleLockAction.reflectRight();
        this.createAction.reflectRight();
        this.deleteAction.reflectRight();
        if (obj instanceof Eigenartikel) {
            this.selectedObject = (Eigenartikel)obj;
            if (this.currentLock != null) {
                CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.currentLock);
                this.toggleLockAction.setChecked(false);
                this.currentLock = null;
            }
            Eigenartikel ea = (Eigenartikel)obj;
            this.toggleLockAction.setEnabled(ea.isProduct());
            if (ea.isProduct()) {
                this.layout.topControl = this.compProduct;
                this.epc.setProductEigenartikel(ea);
            } else {
                this.layout.topControl = this.compArticle;
                this.ec.setEigenartikel(ea);
            }
        } else {
            this.selectedObject = null;
            this.toggleLockAction.setEnabled(false);
            this.epc.setProductEigenartikel(null);
            this.ec.setEigenartikel(null);
            this.layout.topControl = this.compProduct;
        }
        this.container.layout();
    }

    public String getTitle() {
        return Messages.EigenartikelDisplay_displayTitle;
    }

    protected void finalize() throws Throwable {
        if (CoreHub.getLocalLockService().getStatus() != ILocalLockService.Status.STANDALONE) {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_egartikel});
        }
        super.finalize();
    }
}

