/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class DocumentsViewerComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;
    private int catDirection = -1;

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
        if (column == 1) {
            this.catDirection = this.direction;
        }
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String cat2;
        String cat1;
        boolean compareCategories = false;
        int rc = 0;
        if (e1 instanceof ICategory && e2 instanceof ICategory) {
            cat1 = ((ICategory)e1).getName();
            cat2 = ((ICategory)e2).getName();
            compareCategories = true;
        } else {
            IDocument dh1 = (IDocument)e1;
            IDocument dh2 = (IDocument)e2;
            cat1 = dh1.getCategory().getName();
            cat2 = dh2.getCategory().getName();
            switch (this.propertyIndex) {
                case 1: {
                    rc = cat1.compareTo(cat2);
                    break;
                }
                case 2: {
                    if (cat1.equals(cat2)) {
                        rc = dh1.getStatus().getName().compareTo(dh2.getStatus().getName());
                        break;
                    }
                    compareCategories = true;
                    break;
                }
                case 3: {
                    if (cat1.equals(cat2)) {
                        rc = dh1.getLastchanged().compareTo(dh2.getLastchanged());
                        break;
                    }
                    compareCategories = true;
                    break;
                }
                case 4: {
                    if (cat1.equals(cat2)) {
                        rc = dh1.getCreated().compareTo(dh2.getCreated());
                        break;
                    }
                    compareCategories = true;
                    break;
                }
                case 5: {
                    if (cat1.equals(cat2)) {
                        rc = dh1.getTitle().toLowerCase().compareTo(dh2.getTitle().toLowerCase());
                        break;
                    }
                    compareCategories = true;
                    break;
                }
                default: {
                    rc = 0;
                }
            }
        }
        if (compareCategories) {
            rc = cat1.compareTo(cat2);
            if (this.catDirection == 1) {
                rc = -rc;
            }
            return rc;
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public int getDirectionDigit() {
        return this.direction;
    }

    public int getCategoryDirection() {
        return this.catDirection;
    }

    public void setCategoryDirection(int catDirection) {
        this.catDirection = catDirection;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }
}

