/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.documents.views.DocumentsViewerComparator;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsView
extends ViewPart
implements IActivationListener {
    private static Logger logger = LoggerFactory.getLogger(DocumentsView.class);
    private TreeViewer viewer;
    private Tree table;
    public static String importAction_ID = "ch.elexis.omnivore.data.DocumentView.importAction";
    private final String[] colLabels = new String[]{"", Messages.DocumentView_categoryColumn, Messages.DocumentView_stateColumn, Messages.DocumentView_lastChangedColumn, Messages.DocumentView_dateCreatedColumn, Messages.DocumentView_titleColumn, Messages.DocumentsView_extensionColumn, Messages.DocumentView_keywordsColumn};
    private final String colWidth = "20,80,80,80,80,50,150,500";
    private final String sortSettings = "0,1,-1,false";
    private String searchTitle = "";
    private DocumentsViewerComparator ovComparator;
    private Action doubleClickAction;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            DocumentsView.this.viewer.setInput((Object)ev.getObject());
        }
    };
    private final ElexisUiEventListenerImpl eeli_doc_edit = new ElexisUiEventListenerImpl(IDocument.class, 4){

        public void runInUi(ElexisEvent ev) {
            ViewContentProvider viewContentProvider = (ViewContentProvider)DocumentsView.this.viewer.getContentProvider();
            viewContentProvider.updateElement((IDocument)ev.getGenericObject());
        }
    };
    private final ElexisUiEventListenerImpl eeli_doc_create = new ElexisUiEventListenerImpl(IDocument.class, 1){

        public void runInUi(ElexisEvent ev) {
            ViewContentProvider viewContentProvider = (ViewContentProvider)DocumentsView.this.viewer.getContentProvider();
            viewContentProvider.createElement((IDocument)ev.getGenericObject());
        }
    };
    private final ElexisUiEventListenerImpl eeli_doc_delete = new ElexisUiEventListenerImpl(IDocument.class, 2){

        public void runInUi(ElexisEvent ev) {
            ViewContentProvider viewContentProvider = (ViewContentProvider)DocumentsView.this.viewer.getContentProvider();
            viewContentProvider.removeElement((IDocument)ev.getGenericObject());
        }
    };
    private final ElexisUiEventListenerImpl eeli_doc_reload = new ElexisUiEventListenerImpl(IDocument.class, 8){

        public void runInUi(ElexisEvent ev) {
            DocumentsView.this.viewer.refresh();
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        final Text tSearch = new Text(parent, 2048);
        tSearch.setLayoutData((Object)new GridData(4, 128, true, false));
        tSearch.setMessage(Messages.DocumentView_searchLabel);
        ModifyListener searchListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DocumentsView.this.searchTitle = tSearch.getText();
                DocumentsView.this.refresh();
                if (DocumentsView.this.searchTitle == null || DocumentsView.this.searchTitle.isEmpty()) {
                    DocumentsView.this.viewer.collapseAll();
                } else {
                    DocumentsView.this.viewer.expandAll();
                }
            }
        };
        tSearch.addModifyListener(searchListener);
        this.table = new Tree(parent, 66306);
        TreeColumn[] cols = new TreeColumn[this.colLabels.length];
        int i = 0;
        while (i < this.colLabels.length) {
            cols[i] = new TreeColumn(this.table, 0);
            cols[i].setText(this.colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            ++i;
        }
        this.applyUsersColumnWidthSetting();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.viewer = new TreeViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.addFilter((ViewerFilter)new ViewFilterProvider());
        this.ovComparator = new DocumentsViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.ovComparator);
        TreeColumn[] treeCols = this.viewer.getTree().getColumns();
        int i2 = 0;
        while (i2 < treeCols.length) {
            TreeColumn tc = treeCols[i2];
            tc.addSelectionListener(this.getSelectionAdapter(tc, i2));
            ++i2;
        }
        this.makeActions();
        this.applySortDirection();
        this.hookDoubleClickAction();
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    ICategory category = null;
                    if (event.item != null) {
                        if (event.item.getData() instanceof IDocument) {
                            IDocument dh = (IDocument)event.item.getData();
                            category = dh.getCategory();
                        } else if (event.item.getData() instanceof ICategory) {
                            category = (ICategory)event.item.getData();
                        }
                    }
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command cmd = commandService.getCommand("ch.elexis.core.ui.documents.commandCreate");
                    if (files != null) {
                        String[] stringArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String file = stringArray[n2];
                            try {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("documents.file.path", file);
                                if (category != null) {
                                    params.put("documents.category", category.getName());
                                }
                                ExecutionEvent ev = new ExecutionEvent(cmd, params, null, null);
                                cmd.executeWithChecks(ev);
                            }
                            catch (Exception e) {
                                logger.error("drop error", (Throwable)e);
                            }
                            ++n2;
                        }
                    }
                    DocumentsView.this.viewer.refresh();
                }
            }
        });
        Transfer[] dragTransferTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){
            private boolean failure;

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DocumentsView.this.viewer.getSelection();
                event.doit = selection.getFirstElement() instanceof IDocument;
            }

            public void dragSetData(DragSourceEvent event) {
                this.failure = false;
                IStructuredSelection selection = (IStructuredSelection)DocumentsView.this.viewer.getSelection();
                IDocument dh = (IDocument)selection.getFirstElement();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String title = dh.getTitle();
                    int end = dh.getTitle().lastIndexOf(".");
                    if (end != -1) {
                        title = dh.getTitle().substring(0, end);
                    }
                    try {
                        String absPath = DocumentStoreServiceHolder.getService().saveContentToTempFile(dh, title, dh.getExtension(), true);
                        if (absPath != null) {
                            event.data = new String[]{absPath};
                        } else {
                            event.doit = false;
                            this.failure = true;
                        }
                    }
                    catch (ElexisException e) {
                        event.doit = false;
                        this.failure = true;
                        logger.error("drag error", (Throwable)e);
                    }
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (!this.failure) {
                    super.dragFinished(event);
                } else {
                    SWTHelper.showError((String)Messages.DocumentView_exportErrorCaption, (String)Messages.DocumentView_exportErrorEmptyText);
                }
            }
        });
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        MenuManager menuManager = new MenuManager();
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput((Object)ElexisEventDispatcher.getSelectedPatient());
    }

    private SelectionListener getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentsView.this.ovComparator.setColumn(index);
                DocumentsView.this.viewer.getTree().setSortDirection(DocumentsView.this.ovComparator.getDirection());
                DocumentsView.this.viewer.getTree().setSortColumn(column);
                DocumentsView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void applySortDirection() {
        String[] usrSortSettings = "0,1,-1,false".split(",");
        int propertyIdx = Integer.parseInt(usrSortSettings[0]);
        int direction = Integer.parseInt(usrSortSettings[1]);
        if (propertyIdx != 0) {
            this.sortViewer(propertyIdx, direction);
        }
    }

    private void sortViewer(int propertyIdx, int direction) {
        TreeColumn column = this.viewer.getTree().getColumn(propertyIdx);
        this.ovComparator.setColumn(propertyIdx);
        this.ovComparator.setDirection(direction);
        this.viewer.getTree().setSortDirection(this.ovComparator.getDirection());
        this.viewer.getTree().setSortColumn(column);
        this.viewer.refresh();
    }

    private void applyUsersColumnWidthSetting() {
        TreeColumn[] treeColumns = this.table.getColumns();
        String[] userColWidth = "20,80,80,80,80,50,150,500".split(",");
        int i = 0;
        while (i < treeColumns.length) {
            treeColumns[i].setWidth(Integer.parseInt(userColWidth[i]));
            ++i;
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    public void activation(boolean mode) {
        if (!mode) {
            TreeColumn[] treeColumns = this.viewer.getTree().getColumns();
            StringBuilder sb = new StringBuilder();
            TreeColumn[] treeColumnArray = treeColumns;
            int n = treeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tc = treeColumnArray[n2];
                sb.append(tc.getWidth());
                sb.append(",");
                ++n2;
            }
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_doc_delete, this.eeli_doc_edit, this.eeli_doc_create, this.eeli_doc_reload});
            this.viewer.setInput((Object)ElexisEventDispatcher.getSelectedPatient());
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_doc_delete, this.eeli_doc_edit, this.eeli_doc_create, this.eeli_doc_reload});
        }
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = DocumentsView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IDocument) {
                    IDocument dh = (IDocument)obj;
                    DocumentStoreServiceHolder.getService().getPersistenceObject(dh).ifPresent(po -> {
                        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command = commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument");
                        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection(po));
                        try {
                            command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, null, null));
                        }
                        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                            e.printStackTrace();
                        }
                    });
                    DocumentsView.this.viewer.refresh();
                }
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocumentsView.this.doubleClickAction.run();
            }
        });
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private Map<ICategory, List<IDocument>> documentsMap = new HashMap<ICategory, List<IDocument>>();

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput instanceof Patient) {
                this.documentsMap = DocumentStoreServiceHolder.getService().getDocumentsByPatientId(((Patient)newInput).getId());
            } else {
                this.documentsMap.clear();
            }
        }

        public void updateElement(IDocument iDocument) {
            if (iDocument != null) {
                ICategory cachedCategory = this.removeElementsByCachedCategory(iDocument);
                if (!iDocument.getCategory().equals(cachedCategory)) {
                    this.loadElementsByCategory(iDocument, cachedCategory);
                }
                this.loadElementsByCategory(iDocument, iDocument.getCategory());
            }
        }

        public void createElement(IDocument iDocument) {
            List<IDocument> iDocuments = this.documentsMap.get(iDocument.getCategory());
            if (iDocuments == null) {
                iDocuments = new ArrayList<IDocument>();
            }
            iDocuments.add(iDocument);
            this.documentsMap.put(iDocument.getCategory(), iDocuments);
            DocumentsView.this.viewer.refresh(true);
        }

        private Map.Entry<ICategory, IDocument> searchElementById(String id) {
            for (Map.Entry<ICategory, List<IDocument>> entry : this.documentsMap.entrySet()) {
                for (IDocument iDocument : entry.getValue()) {
                    if (!id.equals(iDocument.getId())) continue;
                    return new AbstractMap.SimpleEntry<ICategory, IDocument>(entry.getKey(), iDocument);
                }
            }
            return null;
        }

        private void loadElementsByCategory(IDocument iDocument, ICategory iCategory) {
            List iDocuments = DocumentStoreServiceHolder.getService().getDocumentsByCategory(iDocument.getPatientId(), iCategory);
            if (!iDocuments.isEmpty()) {
                this.documentsMap.put(iCategory, iDocuments);
                DocumentsView.this.viewer.refresh(true);
            }
        }

        private void removeElement(IDocument iDocument) {
            List<IDocument> iDocuments;
            Map.Entry<ICategory, IDocument> entry;
            if (iDocument != null && iDocument.getId() != null && iDocument.getCategory() != null && (entry = this.searchElementById(iDocument.getId())) != null && (iDocuments = this.documentsMap.get(entry.getKey())) != null) {
                iDocuments.remove(iDocument);
                if (iDocuments.isEmpty()) {
                    this.documentsMap.remove(entry.getKey());
                }
                DocumentsView.this.viewer.remove((Object)iDocument);
            }
        }

        private ICategory removeElementsByCachedCategory(IDocument iDocument) {
            Map.Entry<ICategory, IDocument> entry;
            if (iDocument != null && iDocument.getId() != null && iDocument.getCategory() != null && (entry = this.searchElementById(iDocument.getId())) != null) {
                this.documentsMap.remove(entry.getKey());
                return entry.getKey();
            }
            return null;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            ArrayList<ICategory> keys = new ArrayList<ICategory>(this.documentsMap.keySet());
            return keys.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ICategory && this.documentsMap.containsKey(parentElement)) {
                return this.documentsMap.get(parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IDocument) {
                IDocument dh = (IDocument)element;
                return dh.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.documentsMap.containsKey(element);
        }
    }

    class ViewFilterProvider
    extends ViewerFilter {
        ViewFilterProvider() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (DocumentsView.this.searchTitle != null && !DocumentsView.this.searchTitle.isEmpty()) {
                String searchText = DocumentsView.this.searchTitle.toLowerCase();
                if (element instanceof ICategory) {
                    StructuredViewer sviewer = (StructuredViewer)viewer;
                    ITreeContentProvider provider = (ITreeContentProvider)sviewer.getContentProvider();
                    Object[] objectArray = provider.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (this.select(viewer, element, child)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
                if (element instanceof IDocument) {
                    IDocument iDocument = (IDocument)element;
                    if (iDocument.getCategory().getName().toLowerCase().startsWith(searchText)) {
                        return true;
                    }
                    if (iDocument.getTitle().toLowerCase().contains(searchText)) {
                        return true;
                    }
                    if (iDocument.getKeywords().toLowerCase().contains(searchText.toLowerCase())) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ICategory) {
                if (index == 1) {
                    return ((ICategory)obj).getName();
                }
                return null;
            }
            IDocument dh = (IDocument)obj;
            switch (index) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return dh.getStatus().getName();
                }
                case 3: {
                    return new TimeTool(dh.getLastchanged()).toString(0);
                }
                case 4: {
                    return new TimeTool(dh.getCreated()).toString(4);
                }
                case 5: {
                    return dh.getTitle();
                }
                case 6: {
                    return dh.getExtension();
                }
                case 7: {
                    return dh.getKeywords();
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 5) {
                Optional opt;
                if (obj instanceof IDocument && LocalDocumentServiceHolder.getService().isPresent() && (opt = DocumentStoreServiceHolder.getService().getPersistenceObject((IDocument)obj)).isPresent() && ((ILocalDocumentService)LocalDocumentServiceHolder.getService().get()).contains(opt.get())) {
                    return Images.IMG_EDIT.getImage();
                }
            } else if (index == 1 && obj instanceof ICategory) {
                return Images.IMG_FOLDER.getImage();
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

