/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.refintegrity;

import ch.elexis.core.ui.dbcheck.CheckExec;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.core.ui.dbcheck.model.TableDescriptor;
import ch.elexis.core.ui.dbcheck.refintegrity.RefIntegrityCheck;
import ch.rgw.tools.JdbcLink;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class RefIntegrityCheckPGSQL
extends RefIntegrityCheck {
    public RefIntegrityCheckPGSQL() {
        this.oklog = new StringBuilder();
        this.errlog = new StringBuilder();
    }

    @Override
    public String checkReferentialIntegrityStateCoreTables(JdbcLink j, IProgressMonitor monitor) {
        String version = CheckExec.getDBVersion();
        String[] tables = DBModel.getTableModel(version);
        try {
            int i = 0;
            while (i < tables.length) {
                String status = "\u00dcberpr\u00fcfe Tabelle " + tables[i];
                monitor.subTask(status);
                this.oklog.append(String.valueOf(status) + ":\n");
                TableDescriptor tableDetail = DBModel.getTableDescription(tables[i]);
                String[] refIntErrors = tableDetail.getReferentialIntegrityCheck(version);
                if (refIntErrors != null && refIntErrors.length > 0) {
                    int k = 0;
                    while (k < refIntErrors.length) {
                        String description = refIntErrors[k];
                        String query = refIntErrors[k + 1];
                        JdbcLink.Stm stm = j.getStatement();
                        ResultSet rs = stm.query(query);
                        while (rs.next()) {
                            this.errlog.append(String.valueOf(tables[i]) + ": " + rs.getString(1) + " " + description + "\n");
                        }
                        k += 2;
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
        }
        return this.oklog.toString();
    }
}

