/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ReChargeTarmedOpenCons
extends ExternalMaintenance {
    private List<String> problems = new ArrayList<String>();
    protected ICodeElementService codeElementService;
    private ServiceReference<ICodeElementService> serviceRef;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Integer count = 0;
        if (this.initCodeElementService()) {
            boolean presetBillingStrict = CoreHub.userCfg.get("billing/strict", false);
            CoreHub.userCfg.set("billing/strict", false);
            List<Konsultation> consultations = ReChargeTarmedOpenCons.getKonsultation(this.getBeginOfYear(), this.getEndOfYear());
            pm.beginTask("Bitte warten, Tarmed Leistungen werden neu verrechnet", consultations.size());
            for (Konsultation konsultation : consultations) {
                if (konsultation.getRechnung() != null) continue;
                if (pm.isCanceled()) {
                    this.addProblem("Cancelled.", konsultation);
                    return this.getProblemsString();
                }
                List verrechnete = konsultation.getLeistungen();
                List<Verrechnet> tarmedVerrechnet = this.getTarmedOnly(verrechnete);
                for (Verrechnet tarmedVerr : tarmedVerrechnet) {
                    IVerrechenbar verrechenbar = tarmedVerr.getVerrechenbar();
                    if (verrechenbar != null) {
                        Optional matchingVerrechenbar = this.codeElementService.createFromString(verrechenbar.getCodeSystemName(), verrechenbar.getCode(), this.getContext(konsultation));
                        if (matchingVerrechenbar.isPresent()) {
                            int amount = tarmedVerr.getZahl();
                            this.removeVerrechnet(konsultation, tarmedVerr);
                            this.addVerrechnet(konsultation, matchingVerrechenbar, amount);
                            continue;
                        }
                        this.addProblem("Could not find matching Verrechenbar for [" + verrechenbar.getCodeSystemName() + "->" + verrechenbar.getCode() + "]", konsultation);
                        continue;
                    }
                    this.addProblem("Could not find Verrechenbar for [" + tarmedVerr.getLabel() + "]", konsultation);
                }
                count = count + 1;
                pm.worked(1);
            }
            CoreHub.userCfg.set("billing/strict", presetBillingStrict);
            pm.done();
            this.deInitCodeElementService();
        }
        return "Tarmed Leistungen von [" + count + "] Konsultationen des Jahres [" + this.getBeginOfYear().get(1) + "] neu verrechnet" + this.getProblemsString();
    }

    protected TimeTool getBeginOfYear() {
        TimeTool beginOfYear = new TimeTool();
        beginOfYear.set(2, 0);
        beginOfYear.set(5, 1);
        return beginOfYear;
    }

    protected TimeTool getEndOfYear() {
        TimeTool endOfYear = this.getBeginOfYear();
        endOfYear.set(2, 11);
        endOfYear.set(5, 31);
        return endOfYear;
    }

    private void addVerrechnet(Konsultation konsultation, Optional<ICodeElement> matchingVerrechenbar, int amount) {
        int i = 0;
        while (i < amount) {
            Result addRes = konsultation.addLeistung((IVerrechenbar)matchingVerrechenbar.get());
            if (!addRes.isOK()) {
                this.addProblem("Could not add Verrechenbar [" + matchingVerrechenbar.get().getCode() + "]" + "[" + addRes.toString() + "]", konsultation);
            }
            ++i;
        }
    }

    private void removeVerrechnet(Konsultation konsultation, Verrechnet tarmedVerr) {
        LockResponse result = CoreHub.getLocalLockService().acquireLockBlocking((IPersistentObject)tarmedVerr, 10, (IProgressMonitor)new NullProgressMonitor());
        if (result.isOk()) {
            LockResponse releaseLock;
            Result removeRes = konsultation.removeLeistung(tarmedVerr);
            if (!removeRes.isOK()) {
                this.addProblem("Could not remove Verrechnet [" + tarmedVerr.getLabel() + "]" + "[" + removeRes.toString() + "]", konsultation);
            }
            if (!(releaseLock = CoreHub.getLocalLockService().releaseLock(result.getLockInfo())).isOk()) {
                this.addProblem("Could not release lock for Verrechnet [" + tarmedVerr.getLabel() + "]" + "[" + removeRes.toString() + "]", konsultation);
            }
        } else {
            this.addProblem("Could not remove Verrechnet [" + tarmedVerr.getLabel() + "]" + "[ could not acquire lock ]", konsultation);
        }
    }

    private HashMap<Object, Object> getContext(Konsultation consultation) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (consultation != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, consultation);
            Fall coverage = consultation.getFall();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    private void deInitCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        if (this.serviceRef != null) {
            context.ungetService(this.serviceRef);
            this.codeElementService = null;
        }
    }

    private boolean initCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        this.serviceRef = context.getServiceReference(ICodeElementService.class);
        if (this.serviceRef != null) {
            this.codeElementService = (ICodeElementService)context.getService(this.serviceRef);
            return true;
        }
        return false;
    }

    private List<Verrechnet> getTarmedOnly(List<Verrechnet> verrechnete) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        for (Verrechnet verrechnet : verrechnete) {
            String klasse = verrechnet.get("Klasse");
            if (!klasse.endsWith("TarmedLeistung")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    public static List<Konsultation> getKonsultation(TimeTool from, TimeTool to) {
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">=", from.toString(9));
        if (to != null) {
            qbe.add("Datum", "<=", to.toString(9));
        }
        return qbe.execute();
    }

    private String getProblemsString() {
        if (this.problems != null && !this.problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            this.problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(String.valueOf(problem) + "\n");
            });
            return sb.toString();
        }
        return "";
    }

    private void addProblem(String prefix, Konsultation cons) {
        this.problems.add("[" + prefix + "]" + "[" + cons.getId() + "] - [" + cons.getLabel() + "] of [" + cons.getFall().getPatient().getLabel() + "]");
    }

    @Override
    public String getMaintenanceDescription() {
        return "Tarmed Leistungen aller offenen Konsutlationen dieses Jahres neu verrechnen.";
    }
}

