/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class LabCleanup
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Query qp = new Query(Patient.class);
        List results = qp.execute();
        int deletedCount = 0;
        int allCount = 0;
        for (Patient patient : results) {
            HashMap allGrouped = LabResult.getGrouped((Patient)patient);
            Set groups = allGrouped.keySet();
            for (String group : groups) {
                HashMap groupAll = (HashMap)allGrouped.get(group);
                Set items = groupAll.keySet();
                for (String item : items) {
                    HashMap itemAll = (HashMap)groupAll.get(item);
                    Set days = itemAll.keySet();
                    for (String day : days) {
                        List dayAll = (List)itemAll.get(day);
                        deletedCount += this.filterResults(dayAll);
                        allCount += dayAll.size();
                    }
                }
            }
            PersistentObject.resetCache();
        }
        return String.valueOf(deletedCount) + " Werte wurden entfernt.\n " + allCount + " Werte insgesamt.";
    }

    private int filterResults(List<LabResult> dayAll) {
        int deleted = 0;
        LabResult previous = null;
        for (LabResult labResult : dayAll) {
            if (labResult.getResult().isEmpty()) {
                labResult.delete();
                ++deleted;
                continue;
            }
            if (previous != null && this.sameResult(previous, labResult)) {
                labResult.delete();
                ++deleted;
                continue;
            }
            previous = labResult;
        }
        return deleted;
    }

    private boolean sameResult(LabResult left, LabResult right) {
        if (!left.getResult().equals(right.getResult())) {
            return false;
        }
        if (!left.getUnit().equals(right.getUnit())) {
            return false;
        }
        if (!left.getRefFemale().equals(right.getRefFemale())) {
            return false;
        }
        if (!left.getRefMale().equals(right.getRefMale())) {
            return false;
        }
        TimeTool leftObsTime = left.getObservationTime();
        TimeTool rightObsTime = right.getObservationTime();
        if (leftObsTime == null && rightObsTime != null || leftObsTime != null && rightObsTime == null) {
            return false;
        }
        if (leftObsTime != null && rightObsTime != null && !leftObsTime.isEqual(rightObsTime)) {
            return false;
        }
        TimeTool leftAnalyseTime = left.getAnalyseTime();
        TimeTool rightAnalyseTime = right.getAnalyseTime();
        if (leftAnalyseTime == null && rightAnalyseTime != null || leftAnalyseTime != null && rightAnalyseTime == null) {
            return false;
        }
        return leftAnalyseTime == null || rightAnalyseTime == null || leftAnalyseTime.isEqual(rightAnalyseTime);
    }

    @Override
    public String getMaintenanceDescription() {
        return "Mehrfache und leere Laborwerte entfernen.";
    }
}

