/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixMultipleDiagnosis
extends ExternalMaintenance {
    private Logger log = LoggerFactory.getLogger(FixMultipleDiagnosis.class);
    Set<String> uniqueSet = new HashSet<String>();
    private final String STM_S_BDJ = "SELECT BDJ.DiagnoseId FROM BEHDL_DG_JOINT BDJ, DIAGNOSEN D WHERE BDJ.BehandlungsID=? AND D.ID = BDJ.DiagnoseID AND D.DG_CODE=? AND D.KLASSE=?;";

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder sb = new StringBuilder();
        boolean resultOk = true;
        HashMap<String, ArrayList> diagMap = new HashMap<String, ArrayList>();
        HashSet<String> uniqueDiagnosen = new HashSet<String>();
        File file = new File(CoreHub.getWritableUserDir(), "5579_diagnosisFix.csv");
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileWriter fw = new FileWriter(file);){
                Query qre = new Query(Konsultation.class);
                qre.clear(true);
                List execute = qre.execute();
                pm.beginTask("Fixing multiple Diagnoses", execute.size() * 3);
                pm.subTask("Collection diagnosis information");
                for (Konsultation konsultation : execute) {
                    ArrayList diagnosen = konsultation.getDiagnosen();
                    HashSet<String> uniqueDiagnosenThisCons = new HashSet<String>();
                    if (diagnosen.size() > 0) {
                        fw.write(String.valueOf(konsultation.getId()) + ";");
                        Iterator iterator = diagnosen.iterator();
                        while (iterator.hasNext()) {
                            IDiagnose iDiagnose = (IDiagnose)iterator.next();
                            String diagnoseSts = String.valueOf(iDiagnose.getClass().getName()) + "::" + iDiagnose.getCode();
                            uniqueDiagnosen.add(diagnoseSts);
                            uniqueDiagnosenThisCons.add(diagnoseSts);
                        }
                        for (String diagnoseSts : uniqueDiagnosenThisCons) {
                            fw.write(String.valueOf(diagnoseSts) + ";");
                        }
                        diagMap.put(konsultation.getId(), diagnosen);
                        fw.write("\n");
                    } else {
                        sb.append("[" + konsultation.getId() + "] 0 diagnosis entries\n");
                    }
                    pm.worked(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("Error backing up diagnosis", (Throwable)e);
            pm.done();
            return e.getMessage();
        }
        StringBuilder sql = new StringBuilder(200);
        sql.append("DELETE FROM BEHDL_DG_JOINT WHERE 1 = 1");
        PersistentObject.getConnection().exec(sql.toString());
        sql = new StringBuilder(200);
        sql.append("DELETE FROM DIAGNOSEN WHERE 1 = 1");
        PersistentObject.getConnection().exec(sql.toString());
        pm.subTask("Setting diagnosis information");
        Set keySet = diagMap.keySet();
        for (String key : keySet) {
            Konsultation kons = Konsultation.load((String)key);
            ArrayList arrayList = (ArrayList)diagMap.get(key);
            for (IDiagnose iDiagnose : arrayList) {
                this.addDiagnose(kons, iDiagnose);
            }
            pm.worked(1);
        }
        pm.subTask("Validating diagnosis against backup file");
        try {
            List<String> entries = Files.readAllLines(file.toPath());
            for (String line : entries) {
                String[] split = line.split(";");
                List<String> diagnosisEntries = Arrays.asList(Arrays.copyOfRange(split, 1, split.length));
                Konsultation kons = Konsultation.load((String)split[0]);
                ArrayList diagnosen = kons.getDiagnosen();
                int should = diagnosisEntries.size();
                if (diagnosen.size() != should) {
                    sb.append("[" + split[0] + "] # of diagnosis entries mismatch " + should + " " + diagnosen.size() + "\n");
                    resultOk = false;
                } else {
                    for (IDiagnose iDiagnose : diagnosen) {
                        if (diagnosisEntries.contains(String.valueOf(iDiagnose.getClass().getName()) + "::" + iDiagnose.getCode())) continue;
                        sb.append("[" + split[0] + "] missing " + iDiagnose.getClass().getName() + "::" + iDiagnose.getCode() + "\n");
                        resultOk = false;
                    }
                }
                pm.worked(1);
            }
        }
        catch (IOException e) {
            this.log.error("Could not validate", (Throwable)e);
            sb.append("Could not validate diagnosis entries " + e.getMessage());
        }
        pm.done();
        String count = PersistentObject.getConnection().queryString("SELECT COUNT(*) FROM DIAGNOSEN");
        int parseLong = Integer.parseInt(count);
        sb.append("--> No of unique diagnoses matches: " + Boolean.toString(parseLong == uniqueDiagnosen.size()));
        sb.append("Result is equivalent " + resultOk + "\n");
        return sb.toString();
    }

    private void addDiagnose(Konsultation kons, IDiagnose dg) {
        String dgid = this.prepareDiagnoseSelectWithCodeAndClass(kons.getId(), dg.getCode(), dg.getClass().getName());
        if (dgid != null) {
            return;
        }
        String diagnosisEntryExists = PersistentObject.getConnection().queryString("SELECT ID FROM DIAGNOSEN WHERE KLASSE=" + JdbcLink.wrap((String)dg.getClass().getName()) + " AND DG_CODE=" + JdbcLink.wrap((String)dg.getCode()));
        StringBuilder sql = new StringBuilder(200);
        if (StringTool.isNothing((Object)diagnosisEntryExists)) {
            diagnosisEntryExists = StringTool.unique((String)"bhdl");
            sql.append("INSERT INTO DIAGNOSEN (ID, LASTUPDATE, DG_CODE, DG_TXT, KLASSE) VALUES (").append(JdbcLink.wrap((String)diagnosisEntryExists)).append(",").append(Long.toString(System.currentTimeMillis())).append(",").append(JdbcLink.wrap((String)dg.getCode())).append(",").append(JdbcLink.wrap((String)dg.getText())).append(",").append(JdbcLink.wrap((String)dg.getClass().getName())).append(")");
            PersistentObject.getConnection().exec(sql.toString());
            sql.setLength(0);
        }
        sql.append("INSERT INTO BEHDL_DG_JOINT (ID,BEHANDLUNGSID,DIAGNOSEID) VALUES (").append(JdbcLink.wrap((String)StringTool.unique((String)"bhdx"))).append(",").append(kons.getWrappedId()).append(",").append(JdbcLink.wrap((String)diagnosisEntryExists)).append(")");
        PersistentObject.getConnection().exec(sql.toString());
    }

    private String prepareDiagnoseSelectWithCodeAndClass(String konsId, String code, String classname) {
        PreparedStatement pst = PersistentObject.getConnection().getPreparedStatement("SELECT BDJ.DiagnoseId FROM BEHDL_DG_JOINT BDJ, DIAGNOSEN D WHERE BDJ.BehandlungsID=? AND D.ID = BDJ.DiagnoseID AND D.DG_CODE=? AND D.KLASSE=?;");
        try {
            pst.setString(1, konsId);
            pst.setString(2, code);
            pst.setString(3, classname);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            MessageEvent.fireError((String)"Fehler beim L\u00f6schen", (String)e.getMessage(), (Exception)e);
            this.log.error("Error deleting diagnosis", (Throwable)e);
        }
        finally {
            PersistentObject.getConnection().releasePreparedStatement(pst);
        }
        return null;
    }

    @Override
    public String getMaintenanceDescription() {
        return "[5579] Fix multiple diagnosis entry creation";
    }
}

