/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixEmptyDiagnoseKonsultation
extends ExternalMaintenance {
    private HashMap<Mandant, Integer> missingMap;
    private HashMap<Mandant, String> mandantDiagnoseMap;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.missingMap = new HashMap();
        this.mandantDiagnoseMap = new HashMap();
        StringBuilder output = new StringBuilder();
        pm.beginTask("Fixing consultations with no diagnose", 3);
        pm.subTask("Find all consultations ...");
        Query qbe = new Query(Konsultation.class);
        qbe.add("RechnungsID", "", null);
        List kons = qbe.execute();
        pm.worked(1);
        pm.subTask("Find consultations without diagnose ...");
        for (Konsultation k : kons) {
            Fall fall = k.getFall();
            if (fall == null || !fall.exists() || !fall.isOpen() || k.getDiagnosen().size() >= 1) continue;
            Mandant mandant = k.getMandant();
            String diagnoseId = CoreHub.getUserSetting((Kontakt)mandant).get("fall/std_diagnose", "");
            String diagnoseLabel = null;
            if (diagnoseId != null && !diagnoseId.isEmpty()) {
                IDiagnose diagnose = (IDiagnose)CoreHub.poFactory.createFromString(diagnoseId);
                if (diagnose == null) {
                    diagnoseLabel = String.valueOf(diagnoseId) + " existiert nicht";
                } else {
                    k.addDiagnose(diagnose);
                    diagnoseLabel = diagnose.getLabel();
                }
            }
            int found = 1;
            if (this.missingMap.containsKey(mandant)) {
                found = this.missingMap.get(mandant) + 1;
            }
            this.missingMap.put(mandant, found);
            if (this.mandantDiagnoseMap.containsKey(mandant)) continue;
            this.mandantDiagnoseMap.put(mandant, diagnoseLabel);
        }
        pm.worked(1);
        pm.subTask("Show results ...");
        for (Mandant mandant : this.mandantDiagnoseMap.keySet()) {
            String diagnose = this.mandantDiagnoseMap.get(mandant);
            int result = this.missingMap.get(mandant);
            if (diagnose == null) {
                output.append(String.valueOf(mandant.getVorname()) + " " + mandant.getName() + " (" + mandant.getLabel() + "): " + result + " Konsultationen ohne Diagnose (keine Standarddiagnose definiert)\n");
                continue;
            }
            output.append(String.valueOf(mandant.getVorname()) + " " + mandant.getName() + " (" + mandant.getLabel() + "): " + result + " Konsultationen mit Standarddiagnose (" + diagnose + ") vervollst\u00e4ndigt\n");
        }
        pm.worked(1);
        pm.done();
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Standarddiagnose f\u00fcr offene Konsultationen ohne Diagnose eintragen";
    }
}

