/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Query;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class CovercardFixFallFields
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        pm.beginTask("Bitte warten, F\u00e4lle werden geladen ...", -1);
        String billingSystemStd = CoreHub.globalCfg.get("covercard/billinginfo/std/method", null);
        String billingSystemExc = CoreHub.globalCfg.get("covercard/billinginfo/exc/method", null);
        this.updateCovercardBillingSystem();
        if (StringUtils.isNotBlank((String)billingSystemStd) || StringUtils.isNotBlank((String)billingSystemExc)) {
            Query query = new Query(Fall.class);
            query.startGroup();
            query.add("Gesetz", "=", "Covercard");
            if (StringUtils.isNotBlank((String)billingSystemStd)) {
                query.or();
                query.add("Gesetz", "=", billingSystemStd);
            }
            if (StringUtils.isNotBlank((String)billingSystemExc)) {
                query.or();
                query.add("Gesetz", "=", billingSystemExc);
            }
            query.endGroup();
            List coverages = query.execute();
            pm.beginTask("Es wurden " + coverages.size() + " F\u00e4lle geladen diese werden nun gepr\u00fcft, bitte warten ...", coverages.size());
            int covercardCount = 0;
            for (Fall fall : coverages) {
                Object infoElement = fall.getInfoElement("Covercard");
                if (infoElement instanceof Map) {
                    ++covercardCount;
                    String billingSystem = fall.getAbrechnungsSystem();
                    this.updateBillingSystem(billingSystem);
                    Map fields = (Map)infoElement;
                    fall.setInfoString("Versicherungsnummer", StringUtils.defaultIfBlank((String)((String)fields.get("NUM_ASSURE")), (String)""));
                    fall.setInfoString("VEKANr", StringUtils.defaultIfBlank((String)((String)fields.get("NUM_UE")), (String)""));
                    if (StringUtils.isBlank((String)((String)fields.get("VAL_CARTE")))) {
                        fall.setInfoString("VEKAValid", "20991231");
                    } else {
                        fall.setInfoString("VEKAValid", (String)fields.get("VAL_CARTE"));
                    }
                }
                pm.worked(1);
            }
            output.append("Es wurden " + covercardCount + " F\u00e4lle mit covercard Informationen gepr\u00fcft");
            pm.done();
        }
        return output.toString();
    }

    private void updateBillingSystem(String billingSystem) {
        String optionals;
        String requirements = BillingSystem.getRequirements((String)billingSystem);
        if (!requirements.contains("Versicherungsnummer:T")) {
            requirements = StringUtils.isNotBlank((String)requirements) ? String.valueOf(requirements) + ";Versicherungsnummer:T" : "Versicherungsnummer:T";
            CoreHub.globalCfg.set("billing/systems/" + billingSystem + "/bedingungen", requirements);
        }
        if ((optionals = BillingSystem.getOptionals((String)billingSystem)) == null || !optionals.contains("VEKANr")) {
            if (StringUtils.isNotBlank((String)optionals)) {
                if (optionals.endsWith(":")) {
                    optionals = optionals.substring(0, optionals.length() - 1);
                }
                optionals = String.valueOf(optionals) + ";VEKANr:T";
            } else {
                optionals = "VEKANr:T";
            }
            CoreHub.globalCfg.set("billing/systems/" + billingSystem + "/fakultativ", optionals);
        }
    }

    private void updateCovercardBillingSystem() {
        String requirements = BillingSystem.getRequirements((String)"Covercard");
        if (requirements.contains("Versicherten-Nummer:T")) {
            requirements = requirements.contains(";Versicherten-Nummer:T") ? requirements.replace(";Versicherten-Nummer:T", "") : (requirements.contains("Versicherten-Nummer:T;") ? requirements.replace("Versicherten-Nummer:T;", "") : requirements.replace("Versicherten-Nummer:T", ""));
        }
        CoreHub.globalCfg.set("billing/systems/Covercard/bedingungen", requirements);
        String optionals = BillingSystem.getOptionals((String)"Covercard");
        if (optionals == null || !optionals.contains("VEKANr")) {
            optionals = StringUtils.isNotBlank((String)optionals) ? String.valueOf(optionals) + ";VEKANr:T" : "VEKANr:T";
            CoreHub.globalCfg.set("billing/systems/Covercard/fakultativ", optionals);
        }
    }

    @Override
    public String getMaintenanceDescription() {
        return "Covercard Informationen der F\u00e4lle pr\u00fcfen und richtig stellen";
    }
}

