/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.provider;

import ch.elexis.core.model.IContact;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TableDecoratingLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    ITableLabelProvider provider;
    ILabelDecorator decorator;

    public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
        super(provider, decorator);
        this.provider = (ITableLabelProvider)provider;
        this.decorator = decorator;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image decorated;
        Image image = this.provider.getColumnImage(element, columnIndex);
        if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
            return decorated;
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String decorated;
        String text = this.provider.getColumnText(element, columnIndex);
        if (this.decorator != null && (decorated = this.decorator.decorateText(text, element)) != null) {
            return decorated;
        }
        return text;
    }

    public Color getForeground(Object element) {
        IContact c = (IContact)element;
        if (c.isDeleted()) {
            return Display.getCurrent().getSystemColor(3);
        }
        return null;
    }
}

