/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.contacts.dialogs.PatientErfassenDialog;
import ch.elexis.core.ui.contacts.views.PatListFilterBox;
import ch.elexis.core.ui.contacts.views.PatListeContentProvider;
import ch.elexis.core.ui.contacts.views.PatientMenuPopulator;
import ch.elexis.core.ui.data.UiSticker;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Reminder;
import ch.elexis.data.Sticker;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;

public class PatientenListeView
extends ViewPart
implements IActivationListener,
ISaveablePart2,
Heartbeat.HeartListener {
    private CommonViewer cv;
    private ViewerConfigurer vc;
    private ViewMenus menus;
    private RestrictedAction newPatAction;
    private IAction filterAction;
    private IAction copySelectedPatInfosToClipboardAction;
    private IAction copySelectedAddressesToClipboardAction;
    private boolean initiated = false;
    private String[] currentUserFields;
    PatListFilterBox plfb;
    PatListeContentProvider plcp;
    DefaultControlFieldProvider dcfp;
    Composite parent;
    ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            PatientenListeView.this.UserChanged();
        }
    };

    public void dispose() {
        this.plcp.stopListening();
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_user});
        super.dispose();
    }

    public Patient getSelectedPatient() {
        Object[] sel = this.cv.getSelection();
        if (sel != null) {
            return (Patient)sel[0];
        }
        return null;
    }

    public void reload() {
        this.plcp.invalidate();
        this.cv.notify(CommonViewer.Message.update);
    }

    public void createPartControl(final Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.parent = parent;
        this.parent.setLayout((Layout)layout);
        this.cv = new CommonViewer();
        this.collectUserFields();
        this.plcp = new PatListeContentProvider(this.cv, this.currentUserFields, this);
        this.makeActions();
        this.plfb = new PatListFilterBox(parent);
        this.plfb.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        ((GridData)this.plfb.getLayoutData()).heightHint = 0;
        this.dcfp = new DefaultControlFieldProvider(this.cv, this.currentUserFields);
        this.updateFocusField();
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.plcp, (LabelProvider)new PatLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.dcfp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 4, this.cv));
        this.cv.create(this.vc, parent, 0, (Object)this.getViewSite());
        this.cv.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)new ControlFieldSelectionListener());
        this.cv.getViewerWidget().getControl().setFont(UiDesk.getFont((String)"anwender/stdfont"));
        this.plcp.startListening();
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_user});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.populateViewMenu();
        StructuredViewer viewer = this.cv.getViewerWidget();
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyDialogAction pdAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider());
                if (pdAction.isApplicableForSelection()) {
                    pdAction.run();
                }
            }
        });
        this.getSite().registerContextMenu(this.menus.getContextMenu(), (ISelectionProvider)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
    }

    private void updateFocusField() {
        String ff = CoreHub.userCfg.get("anwender/patlist/focusfield", null);
        if (ff != null) {
            this.dcfp.setFocusField(ff);
        }
    }

    private void collectUserFields() {
        ArrayList<String> fields = new ArrayList<String>();
        boolean bl = this.initiated = !"".equals(CoreHub.userCfg.get("anwender/patlist/zeigenr", ""));
        if (CoreHub.userCfg.get("anwender/patlist/zeigenr", false)) {
            fields.add("PatientNr=" + Messages.PatientenListeView_PatientNr);
        }
        if (CoreHub.userCfg.get("anwender/patlist/zeigename", true)) {
            fields.add("Name=" + Messages.PatientenListeView_PatientName);
        }
        if (CoreHub.userCfg.get("anwender/patlist/zeigevorname", true)) {
            fields.add("Vorname=" + Messages.PatientenListeView_PantientFirstName);
        }
        if (CoreHub.userCfg.get("anwender/patlist/zeigegebdat", true)) {
            fields.add("Geburtsdatum=" + Messages.PatientenListeView_PatientBirthdate);
        }
        this.currentUserFields = fields.toArray(new String[fields.size()]);
    }

    private void populateViewMenu() {
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[]{this.newPatAction, this.filterAction});
        this.menus.createToolbar(new IAction[]{this.copySelectedPatInfosToClipboardAction});
        this.menus.createToolbar(new IAction[]{this.copySelectedAddressesToClipboardAction});
        PatientMenuPopulator pmp = new PatientMenuPopulator(this, this.cv.getViewerWidget());
        this.menus.createControlContextMenu(this.cv.getViewerWidget().getControl(), (ViewMenus.IMenuPopulator)pmp);
        this.menus.getContextMenu().addMenuListener((IMenuListener)pmp);
        this.menus.createMenu(new IAction[]{this.newPatAction, this.filterAction});
        this.menus.createMenu(new IAction[]{this.copySelectedPatInfosToClipboardAction});
        this.menus.createMenu(new IAction[]{this.copySelectedAddressesToClipboardAction});
    }

    public PatListeContentProvider getContentProvider() {
        return this.plcp;
    }

    public void setFocus() {
        this.vc.getControlFieldProvider().setFocus();
    }

    public void reset() {
        this.vc.getControlFieldProvider().clearValues();
    }

    private void makeActions() {
        this.filterAction = new Action(Messages.PatientenListeView_FilteList, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_FilterList);
            }

            public void run() {
                GridData gd = (GridData)PatientenListeView.this.plfb.getLayoutData();
                if (PatientenListeView.this.filterAction.isChecked()) {
                    gd.heightHint = 80;
                    PatientenListeView.this.plfb.reset();
                    PatientenListeView.this.plcp.setFilter(PatientenListeView.this.plfb);
                } else {
                    gd.heightHint = 0;
                    PatientenListeView.this.plcp.removeFilter(PatientenListeView.this.plfb);
                }
                PatientenListeView.this.parent.layout(true);
            }
        };
        this.newPatAction = new RestrictedAction(AccessControlDefaults.PATIENT_INSERT, Messages.PatientenListeView_NewPatientAction){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_NewPationtToolTip);
            }

            public void doRun() {
                PatientErfassenDialog ped;
                HashMap<String, String> ctlFields = new HashMap<String, String>();
                String[] fx = PatientenListeView.this.vc.getControlFieldProvider().getValues();
                int i = 0;
                if (CoreHub.userCfg.get("anwender/patlist/zeigenr", false) && i < fx.length) {
                    ctlFields.put("PatientNr", fx[i++]);
                }
                if (CoreHub.userCfg.get("anwender/patlist/zeigename", true) && i < fx.length) {
                    ctlFields.put("Name", fx[i++]);
                }
                if (CoreHub.userCfg.get("anwender/patlist/zeigevorname", true) && i < fx.length) {
                    ctlFields.put("Vorname", fx[i++]);
                }
                if (CoreHub.userCfg.get("anwender/patlist/zeigegebdat", true) && i < fx.length) {
                    ctlFields.put("Geburtsdatum", fx[i++]);
                }
                if ((ped = new PatientErfassenDialog(PatientenListeView.this.getViewSite().getShell(), ctlFields)).open() == 0) {
                    PatientenListeView.this.plcp.temporaryAddObject(ped.getResult());
                    Patient pat = ped.getResult();
                    int j = 0;
                    while (j < PatientenListeView.this.currentUserFields.length) {
                        String current = PatientenListeView.this.currentUserFields[j];
                        if (current.startsWith("PatientNr")) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getPatCode());
                        } else if (current.startsWith("Name") && pat.getName() != null) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getName());
                        } else if (current.startsWith("Vorname") && pat.getVorname() != null) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getVorname());
                        }
                        ++j;
                    }
                    PatientenListeView.this.plcp.syncRefresh();
                    TableViewer tv = (TableViewer)PatientenListeView.this.cv.getViewerWidget();
                    tv.setSelection((ISelection)new StructuredSelection((Object)pat), true);
                }
            }
        };
        this.copySelectedPatInfosToClipboardAction = new Action(Messages.PatientenListeView_copySelectedPatInfosToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_copySelectedPatInfosToClipboard);
            }

            public void run() {
                StringBuffer selectedPatInfosText = new StringBuffer();
                Object[] sel = PatientenListeView.this.cv.getSelection();
                if (sel != null && sel.length > 0) {
                    int i = 0;
                    while (i < sel.length) {
                        Patient k = (Patient)sel[i];
                        if (k.istPerson()) {
                            String thisAddressFLD_E_MAIL;
                            String thisAddressFLD_FAX;
                            String thisAddressFLD_MOBILEPHONE;
                            String thisAddressFLD_PHONE2;
                            String thisAddressFLD_PHONE1;
                            String thisAddressFLD_PLACE;
                            String thisAddressFLD_ZIP;
                            String thisAddressFLD_COUNTRY;
                            String thisAddressFLD_STREET;
                            String thisPatientBIRTHDATE;
                            String salutation = k.getGeschlecht().equals("m") ? Messages.KontakteView_SalutationM : (k.getGeschlecht().equals("w") ? Messages.KontakteView_SalutationF : "");
                            selectedPatInfosText.append(salutation);
                            selectedPatInfosText.append(" ");
                            String titel = k.get("Titel");
                            if (!StringTool.isNothing((Object)titel)) {
                                selectedPatInfosText.append(titel).append(" ");
                            }
                            if (!StringTool.isNothing((Object)k.getName())) {
                                selectedPatInfosText.append(String.valueOf(k.getName()) + " ");
                            }
                            if (!StringTool.isNothing((Object)k.getVorname())) {
                                selectedPatInfosText.append(k.getVorname());
                            }
                            if (!StringTool.isNothing((Object)(thisPatientBIRTHDATE = k.get("Geburtsdatum")))) {
                                selectedPatInfosText.append(", " + new TimeTool(thisPatientBIRTHDATE).toString(4));
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_STREET = k.get("Strasse")))) {
                                selectedPatInfosText.append(", " + thisAddressFLD_STREET);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_COUNTRY = k.get("Land")))) {
                                selectedPatInfosText.append(", " + thisAddressFLD_COUNTRY + "-");
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_ZIP = k.get("Plz")))) {
                                if (StringTool.isNothing((Object)thisAddressFLD_COUNTRY)) {
                                    selectedPatInfosText.append(", ");
                                }
                                selectedPatInfosText.append(thisAddressFLD_ZIP);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_PLACE = k.get("Ort")))) {
                                if (StringTool.isNothing((Object)thisAddressFLD_COUNTRY) && StringTool.isNothing((Object)thisAddressFLD_ZIP)) {
                                    selectedPatInfosText.append(",");
                                }
                                selectedPatInfosText.append(" " + thisAddressFLD_PLACE);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_PHONE1 = k.get("Telefon1")))) {
                                selectedPatInfosText.append(",  " + thisAddressFLD_PHONE1);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_PHONE2 = k.get("Telefon2")))) {
                                selectedPatInfosText.append(",  " + thisAddressFLD_PHONE2);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_MOBILEPHONE = k.get("NatelNr")))) {
                                selectedPatInfosText.append(", NatelNr " + thisAddressFLD_MOBILEPHONE);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_FAX = k.get("Fax")))) {
                                selectedPatInfosText.append(", Fax " + thisAddressFLD_FAX);
                            }
                            if (!StringTool.isNothing((Object)(thisAddressFLD_E_MAIL = k.get("E-Mail")))) {
                                selectedPatInfosText.append(", " + thisAddressFLD_E_MAIL);
                            }
                        } else {
                            selectedPatInfosText.append("Fehler: Bei diesem Patienten ist das Flag \"Person\" nicht gesetzt! Bitte korrigieren!\n");
                        }
                        if (i < sel.length - 1) {
                            selectedPatInfosText.append(System.getProperty("line.separator"));
                        }
                        ++i;
                    }
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{selectedPatInfosText.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
        this.copySelectedAddressesToClipboardAction = new Action(Messages.PatientenListeView_copySelectedAddressesToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_copySelectedAddressesToClipboard);
            }

            public void run() {
                StringBuffer selectedAddressesText = new StringBuffer();
                Object[] sel = PatientenListeView.this.cv.getSelection();
                if (sel != null && sel.length > 0) {
                    int i = 0;
                    while (i < sel.length) {
                        Patient k = (Patient)sel[i];
                        selectedAddressesText.append(k.getPostAnschriftPhoneFaxEmail(true, true));
                        if (i < sel.length - 1) {
                            selectedAddressesText.append(System.getProperty("line.separator"));
                        }
                        ++i;
                    }
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{selectedAddressesText.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
    }

    public void activation(boolean mode) {
        if (mode) {
            this.newPatAction.reflectRight();
            this.heartbeat();
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void visible(boolean mode) {
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return GlobalActions.fixLayoutAction.isChecked();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void heartbeat() {
        this.cv.notify(CommonViewer.Message.update);
    }

    public void UserChanged() {
        if (!this.initiated) {
            SWTHelper.reloadViewPart((String)"ch.elexis.PatListView");
        }
        if (!this.cv.getViewerWidget().getControl().isDisposed()) {
            this.cv.getViewerWidget().getControl().setFont(UiDesk.getFont((String)"anwender/stdfont"));
            this.cv.notify(CommonViewer.Message.update);
            this.collectUserFields();
            this.dcfp.updateFields(this.currentUserFields, true);
            this.plcp.updateFields(this.currentUserFields);
            this.updateFocusField();
            this.dcfp.getParent().layout(true);
        }
    }

    class ControlFieldSelectionListener
    implements ViewerConfigurer.ControlFieldListener {
        ControlFieldSelectionListener() {
        }

        public void changed(HashMap<String, String> values) {
        }

        public void reorder(String field) {
        }

        public void selected() {
            Object element;
            StructuredViewer viewer = PatientenListeView.this.cv.getViewerWidget();
            Object[] elements = PatientenListeView.this.cv.getConfigurer().getContentProvider().getElements(viewer.getInput());
            if (elements != null && elements.length > 0 && (element = elements[0]) instanceof PersistentObject) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)element));
            }
        }
    }

    class PatLabelProvider
    extends DefaultLabelProvider
    implements ITableColorProvider {
        PatLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Patient) {
                Patient pat = (Patient)element;
                if (Reminder.findRemindersDueFor((Patient)pat, (Anwender)CoreHub.actUser, (boolean)false).size() > 0) {
                    return Images.IMG_AUSRUFEZ.getImage();
                }
                ISticker et = pat.getSticker();
                Image im = null;
                if (et != null && (im = new UiSticker((Sticker)et).getImage()) != null) {
                    return im;
                }
                if (pat.getGeschlecht().equals("m")) {
                    return Images.IMG_MANN.getImage();
                }
                return Images.IMG_FRAU.getImage();
            }
            return super.getColumnImage(element, columnIndex);
        }

        public Color getBackground(Object element, int columnIndex) {
            Patient pat;
            ISticker et;
            if (element instanceof Patient && (et = (pat = (Patient)element).getSticker()) != null) {
                return UiDesk.getColorFromRGB((String)et.getBackground());
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            Patient pat;
            ISticker et;
            if (element instanceof Patient && (et = (pat = (Patient)element).getSticker()) != null) {
                return UiDesk.getColorFromRGB((String)et.getForeground());
            }
            return null;
        }
    }
}

