/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.contacts.views.PatientenListeView;
import ch.elexis.core.ui.dialogs.AssignStickerDialog;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class PatientMenuPopulator
implements ViewMenus.IMenuPopulator,
IMenuListener {
    IAction exportKGAction;
    IAction stickerAction;
    RestrictedAction delPatAction;
    PatientenListeView mine;

    public IAction[] fillMenu() {
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(this.stickerAction);
        ret.add(this.delPatAction);
        if (CoreHub.acl.request(AccessControlDefaults.KONTAKT_EXPORT)) {
            ret.add(this.exportKGAction);
        }
        this.delPatAction.reflectRight();
        this.exportKGAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.KONTAKT_EXPORT));
        return ret.toArray(new IAction[0]);
    }

    PatientMenuPopulator(PatientenListeView plv, final StructuredViewer structuredViewer) {
        this.mine = plv;
        this.stickerAction = new RestrictedAction(AccessControlDefaults.KONTAKT_ETIKETTE, Messages.PatientMenuPopulator_StickerAction){
            {
                this.setToolTipText(Messages.PatientMenuPopulator_StickerToolTip);
            }

            public void doRun() {
                Patient p = PatientMenuPopulator.this.mine.getSelectedPatient();
                AssignStickerDialog aed = new AssignStickerDialog(Hub.getActiveShell(), (PersistentObject)p);
                aed.open();
            }
        };
        this.delPatAction = new LockRequestingRestrictedAction<Patient>(AccessControlDefaults.KONTAKT_DELETE, Messages.PatientMenuPopulator_DeletePatientAction){

            public void doRun(Patient p) {
                if (MessageDialog.openConfirm((Shell)PatientMenuPopulator.this.mine.getViewSite().getShell(), (String)Messages.PatientMenuPopulator_DeletePatientConfirm, (String)p.getLabel())) {
                    if (!p.delete(false)) {
                        SWTHelper.alert((String)Messages.PatientMenuPopulator_DeletePatientRejectCaption, (String)Messages.PatientMenuPopulator_DeletePatientRejectBody);
                    } else {
                        PatientMenuPopulator.this.mine.reload();
                    }
                }
            }

            public Patient getTargetedObject() {
                StructuredSelection selection = (StructuredSelection)structuredViewer.getSelection();
                if (selection != null) {
                    return (Patient)selection.getFirstElement();
                }
                return null;
            }
        };
        this.exportKGAction = new Action(Messages.PatientMenuPopulator_ExportEMRAction, 4){
            Menu menu;
            {
                this.menu = null;
                this.setToolTipText(Messages.PatientMenuPopulator_ExportEMRToolTip);
                this.setMenuCreator(new IMenuCreator(){

                    public void dispose() {
                        if (menu != null) {
                            menu.dispose();
                            menu = null;
                        }
                    }

                    public Menu getMenu(Control parent) {
                        menu = new Menu(parent);
                        this.createMenu();
                        return menu;
                    }

                    public Menu getMenu(Menu parent) {
                        menu = new Menu(parent);
                        this.createMenu();
                        return menu;
                    }
                });
            }

            void createMenu() {
                Patient p = PatientMenuPopulator.this.mine.getSelectedPatient();
                if (p != null) {
                    List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Transporter");
                    for (final IConfigurationElement ic : list) {
                        String handler = ic.getAttribute("AcceptableTypes");
                        if (handler == null || !handler.contains("ch.elexis.data.Patient") && !handler.contains("ch.elexis.data.*")) continue;
                        MenuItem it = new MenuItem(this.menu, 0);
                        it.setText(ic.getAttribute("name"));
                        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Patient pat = (this).PatientMenuPopulator.this.mine.getSelectedPatient();
                                try {
                                    IDataSender sender = (IDataSender)ic.createExecutableExtension("ExporterClass");
                                    sender.store((Object)pat);
                                    sender.finalizeExport();
                                    SWTHelper.showInfo((String)Messages.PatientMenuPopulator_EMRExported, (String)MessageFormat.format(Messages.PatientMenuPopulator_ExportEmrSuccess, pat.getLabel()));
                                }
                                catch (CoreException e1) {
                                    ExHandler.handle((Throwable)e1);
                                }
                                catch (XChangeException xx) {
                                    SWTHelper.showError((String)Messages.PatientMenuPopulator_ErrorCaption, (String)MessageFormat.format(Messages.PatientMenuPopulator_ExportEmrFailure, pat.getLabel()));
                                }
                            }
                        });
                    }
                }
            }
        };
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.delPatAction.setEnabled(this.delPatAction.isEnabled());
        manager.update(true);
    }
}

