/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.contacts.views.PatListFilterBox;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class PatListeContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ILazyContentProvider {
    CommonViewer viewer;
    Query<Patient> qbe;
    Object[] pats;
    boolean bValid = false;
    boolean bUpdating = false;
    String[] orderLabels;
    String[] orderFields;
    String firstOrder;
    PatListFilterBox pfilter;
    ViewPart site;

    public PatListeContentProvider(CommonViewer cv, String[] fieldsToOrder, ViewPart s) {
        this.viewer = cv;
        this.site = s;
        this.updateFields(fieldsToOrder);
    }

    public void updateFields(String[] fieldsToOrder) {
        this.orderLabels = new String[fieldsToOrder.length];
        this.orderFields = new String[fieldsToOrder.length];
        int i = 0;
        while (i < fieldsToOrder.length) {
            String[] def = fieldsToOrder[i].split("=");
            this.orderFields[i] = def[0];
            this.orderLabels[i] = def.length > 1 ? def[1] : def[0];
            ++i;
        }
        this.firstOrder = this.orderFields[0];
    }

    public void startListening() {
        this.viewer.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)this);
        this.qbe = new Query(Patient.class);
    }

    public void stopListening() {
        if (this.viewer != null) {
            this.viewer.getConfigurer().getControlFieldProvider().removeChangeListener((ViewerConfigurer.ControlFieldListener)this);
        }
    }

    public void setFilter(PatListFilterBox f) {
        this.qbe.addPostQueryFilter((IFilter)f);
        this.pfilter = f;
        this.bValid = false;
    }

    public void removeFilter(PatListFilterBox f) {
        this.qbe.removePostQueryFilter((IFilter)f);
        this.pfilter = null;
        this.bValid = false;
    }

    public void syncRefresh() {
        String[] actualOrder;
        this.qbe.clear();
        this.viewer.getConfigurer().getControlFieldProvider().setQuery(this.qbe);
        int idx = StringTool.getIndex((String[])this.orderFields, (String)this.firstOrder);
        if (idx == -1 || idx == 0) {
            actualOrder = this.orderFields;
        } else {
            actualOrder = new String[this.orderFields.length];
            int n = 0;
            int begin = idx;
            do {
                actualOrder[n++] = this.orderFields[idx++];
                if (idx < this.orderFields.length) continue;
                idx = 0;
            } while (idx != begin);
        }
        this.qbe.orderBy(false, actualOrder);
        List lPats = this.qbe.execute();
        this.pats = lPats == null ? new Patient[0] : lPats.toArray(new Patient[0]);
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TableViewer tv = (TableViewer)PatListeContentProvider.this.viewer.getViewerWidget();
                tv.setItemCount(PatListeContentProvider.this.pats.length);
                PatListeContentProvider.this.bValid = true;
                if (PatListeContentProvider.this.pfilter != null) {
                    PatListeContentProvider.this.pfilter.finished();
                }
                tv.refresh();
                PatListeContentProvider.this.bUpdating = false;
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        if (this.bValid || this.bUpdating) {
            return this.pats;
        }
        if (this.pfilter != null) {
            this.pats = new String[]{Messages.PatListeContentProvider_LoadingData};
            ((TableViewer)this.viewer.getViewerWidget()).setItemCount(1);
        }
        if (!CoreHub.acl.request(AccessControlDefaults.PATIENT_DISPLAY)) {
            return new Object[0];
        }
        Job job = new Job(Messages.PatListeContentProvider_LoadingPatients){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PatListeContentProvider_LoadPatients, -1);
                if (PatListeContentProvider.this.pfilter != null && !PatListeContentProvider.this.pfilter.aboutToStart()) {
                    return Status.CANCEL_STATUS;
                }
                PatListeContentProvider.this.syncRefresh();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(false);
        this.bUpdating = true;
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.site.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)Images.IMG_AUSRUFEZ_ROT.getImage());
        return this.pats;
    }

    public void dispose() {
        this.stopListening();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void changed(HashMap<String, String> vals) {
        this.bValid = false;
        this.getElements(this.viewer);
        if (this.viewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.viewer.notify(CommonViewer.Message.empty);
        } else {
            this.viewer.notify(CommonViewer.Message.notempty);
        }
    }

    public void reorder(String field) {
        int idx = StringTool.getIndex((String[])this.orderLabels, (String)field);
        if (idx > -1) {
            this.firstOrder = this.orderFields[idx];
            this.changed(null);
        }
    }

    public void selected() {
    }

    public void updateElement(int index) {
        if (!this.bValid) {
            this.getElements(this.viewer);
        }
        TableViewer tv = (TableViewer)this.viewer.getViewerWidget();
        if (this.pats.length > index) {
            tv.replace(this.pats[index], index);
        } else {
            Object elementAt = tv.getElementAt(index);
            if (elementAt != null) {
                tv.replace((Object)"-", index);
            }
        }
    }

    public void invalidate() {
        this.bValid = false;
    }

    void temporaryAddObject(Object newObject) {
        ArrayList<Object> temp = null;
        temp = this.pats != null ? new ArrayList<Object>(Arrays.asList(this.pats)) : new ArrayList<Object>();
        temp.add(newObject);
        this.pats = temp.toArray();
        ((TableViewer)this.viewer.getViewerWidget()).setItemCount(this.pats.length);
    }

    public void init() {
    }
}

