/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.core.data.beans.ContactBeanFactory;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IContact;
import ch.elexis.core.ui.contacts.views.comparator.ContactSelectorViewerComparator;
import ch.elexis.core.ui.contacts.views.dnd.ContactSelectorDragListener;
import ch.elexis.core.ui.contacts.views.dnd.ContactSelectorDropListener;
import ch.elexis.core.ui.contacts.views.filter.KontaktAnzeigeTextFieldViewerFilter;
import ch.elexis.core.ui.contacts.views.filter.KontaktAnzeigeTypViewerFilter;
import ch.elexis.core.ui.contacts.views.provider.ContactSelectorObservableMapLabelProvider;
import ch.elexis.core.ui.contacts.views.provider.TableDecoratingLabelProvider;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ContactSelectorView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String ID = "ch.elexis.core.ui.contacts.views.ContactSelectorView";
    private ObservableListContentProvider contentProvider = null;
    private TableViewer tableViewerContacts;
    private WritableList contactList = new WritableList();
    private Text txtFilter;
    private KontaktAnzeigeTypViewerFilter filterAnzeigeTyp;
    private KontaktAnzeigeTextFieldViewerFilter filterPositionTitle;
    private LoadContactsRunnable loadContactsRunnable;
    private Label lblStatus;

    public ContactSelectorView() {
        this.contentProvider = new ObservableListContentProvider();
        this.filterPositionTitle = new KontaktAnzeigeTextFieldViewerFilter();
        this.loadContactsRunnable = new LoadContactsRunnable();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite compositeSearch = new Composite(composite, 0);
        compositeSearch.setLayout((Layout)new GridLayout(1, false));
        compositeSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtFilter = new Text(compositeSearch, 2432);
        this.txtFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tableViewerContacts = new TableViewer(composite, 67584);
        Table table = this.tableViewerContacts.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite compositeStatus = new Composite(composite, 0);
        compositeStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeStatus.setLayout((Layout)new GridLayout(1, false));
        this.lblStatus = new Label(compositeStatus, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tableViewerContacts.setComparator((ViewerComparator)new ContactSelectorViewerComparator((Viewer)this.tableViewerContacts));
        this.filterAnzeigeTyp = new KontaktAnzeigeTypViewerFilter((Viewer)this.tableViewerContacts);
        ViewerFilter[] filters = new ViewerFilter[]{this.filterAnzeigeTyp, this.filterPositionTitle};
        this.tableViewerContacts.setFilters(filters);
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tableViewerContacts.addDragSupport(operations, transferTypes, (DragSourceListener)new ContactSelectorDragListener(this.tableViewerContacts));
        this.tableViewerContacts.addDropSupport(operations, transferTypes, (DropTargetListener)new ContactSelectorDropListener((Viewer)this.tableViewerContacts));
        this.txtFilter.addKeyListener((KeyListener)new FilterKeyListener(this.txtFilter, (StructuredViewer)this.tableViewerContacts));
        this.txtFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    ContactSelectorView.this.filterPositionTitle.setSearchText(null);
                    ContactSelectorView.this.tableViewerContacts.getControl().setRedraw(false);
                    ContactSelectorView.this.tableViewerContacts.refresh();
                    ContactSelectorView.this.tableViewerContacts.getControl().setRedraw(true);
                }
            }
        });
        this.initDataBindings();
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.tableViewerContacts.getTable().setMenu(menuManager.createContextMenu((Control)this.tableViewerContacts.getTable()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewerContacts);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewerContacts);
        this.contactList.getRealm().asyncExec((Runnable)this.loadContactsRunnable);
        this.tableViewerContacts.addSelectionChangedListener((ISelectionChangedListener)new ContactSelectionChangedToEventDispatcher());
        this.tableViewerContacts.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                ContactSelectorView.this.tableViewerContacts.refresh(ss.getFirstElement());
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.tableViewerContacts.setContentProvider((IContentProvider)this.contentProvider);
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)this.contentProvider.getKnownElements(), IContact.class, (String[])new String[]{"description1", "description2", "mandator", "patient", "user"});
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.tableViewerContacts.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new ContactSelectorObservableMapLabelProvider(observeMaps), decorator));
        this.tableViewerContacts.setInput((Object)this.contactList);
        return bindingContext;
    }

    public void addContact(IContact contact) {
        this.contactList.add((Object)contact);
    }

    public void setFocus() {
        this.txtFilter.setFocus();
        this.tableViewerContacts.refresh();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    private class ContactSelectionChangedToEventDispatcher
    implements ISelectionChangedListener {
        private ContactSelectionChangedToEventDispatcher() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IContact contact;
            ISelection selection = event.getSelection();
            if (selection == null) {
                return;
            }
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            Object selectedObject = strucSelection.getFirstElement();
            if (selectedObject == null) {
                return;
            }
            if (selectedObject instanceof IContact && (contact = (IContact)selectedObject).isPatient()) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)Patient.load((String)contact.getId()));
            }
        }
    }

    private class FilterKeyListener
    extends KeyAdapter {
        private Text text;
        private StructuredViewer viewer;

        FilterKeyListener(Text filterTxt, StructuredViewer viewer) {
            this.text = filterTxt;
            this.viewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            this.text.setMessage("");
        }

        public void keyReleased(KeyEvent ke) {
            String txt = this.text.getText();
            if (txt.startsWith("=")) {
                if (txt.contains(";")) {
                    String formula = txt.substring(1, txt.indexOf(";"));
                    HashMap<String, Class<Math>> functions = new HashMap<String, Class<Math>>();
                    functions.put("math", Math.class);
                    JexlEngine jexl = new JexlEngine();
                    jexl.setLenient(false);
                    jexl.setFunctions(functions);
                    try {
                        Expression expr = jexl.createExpression(formula);
                        Object result = expr.evaluate((JexlContext)new MapContext());
                        this.text.setText("");
                        this.text.setMessage(String.valueOf(formula) + "=" + result);
                        result = null;
                    }
                    catch (JexlException e) {
                        this.text.setText("");
                        this.text.setMessage("Invalid expression: " + formula);
                    }
                }
                return;
            }
            if (txt.length() > 1) {
                ContactSelectorView.this.filterPositionTitle.setSearchText(txt);
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.getControl().setRedraw(true);
            } else {
                ContactSelectorView.this.filterPositionTitle.setSearchText(null);
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.getControl().setRedraw(true);
            }
        }
    }

    private class LoadContactsRunnable
    implements Runnable {
        private LoadContactsRunnable() {
        }

        @Override
        public void run() {
            Query qbe = new Query(Kontakt.class, null, null, "KONTAKT", new String[]{"deleted", "istPerson", "istOrganisation", "istMandant", "istAnwender", "istPatient", "Bezeichnung1", "Bezeichnung2", "Bezeichnung3", "Geburtsdatum", "Geschlecht", "PatientNr", "Titel", "TitelSuffix"});
            List qre = qbe.execute();
            List result = ContactBeanFactory.createContactBeans((List)qre);
            ContactSelectorView.this.lblStatus.setText(String.valueOf(qbe.size()) + " contacts found.");
            ContactSelectorView.this.tableViewerContacts.getControl().setRedraw(false);
            ContactSelectorView.this.contactList.clear();
            ContactSelectorView.this.contactList.addAll((Collection)result);
            ContactSelectorView.this.tableViewerContacts.getControl().setRedraw(true);
        }
    }
}

