/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.mail.MailAccount;
import java.util.Properties;

public class MailClientProperties {
    private MailAccount account;

    public MailClientProperties(MailAccount account) {
        this.account = account;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.account.getType() == MailAccount.TYPE.SMTP) {
            props.put("mail.transport.protocol", "smtp");
            if (this.account.getUsername() != null && this.account.getPassword() != null) {
                props.put("mail.user", this.account.getUsername());
                props.put("mail.smtp.auth", "true");
            }
            props.put("mail.smtp.host", this.account.getHost());
            props.put("mail.smtp.port", this.account.getPort());
            props.put("mail.smtp.starttls.enable", Boolean.toString(this.account.isStarttls()));
        } else if (this.account.getType() == MailAccount.TYPE.IMAP) {
            props.put("mail.transport.protocol", "imaps");
            props.put("mail.imaps.host", this.account.getHost());
            props.put("mail.imaps.port", this.account.getPort());
        }
        props.put("mail.debug", "true");
        return props;
    }
}

