/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.mail.IMailClient;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.internal.MailClientProperties;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MailClient
implements IMailClient {
    private static final Logger logger = LoggerFactory.getLogger(MailClient.class);
    private static final String CONFIG_ACCOUNTS = "ch.elexis.core.mail/accounts";
    private static final String CONFIG_ACCOUNT = "ch.elexis.core.mail/account";
    private static final String ACCOUNTS_SEPARATOR = ",";
    private IMailClient.ErrorTyp lastError;

    @Override
    public Optional<IMailClient.ErrorTyp> getLastError() {
        IMailClient.ErrorTyp ret = this.lastError;
        this.lastError = null;
        return Optional.ofNullable(ret);
    }

    @Override
    public Optional<MailAccount> getAccount(String id) {
        MailAccount ret = null;
        String accountString = CoreHub.globalCfg.get("ch.elexis.core.mail/account/" + id, null);
        if (accountString != null) {
            ret = MailAccount.from(accountString);
        }
        return Optional.ofNullable(ret);
    }

    @Override
    public List<String> getAccounts() {
        ArrayList<String> ret = new ArrayList<String>();
        String accountIds = CoreHub.globalCfg.get(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            ret.addAll(Arrays.asList(currentIds));
        }
        return ret;
    }

    @Override
    public void saveAccount(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.addAccountId(account.getId());
            CoreHub.globalCfg.set("ch.elexis.core.mail/account/" + account.getId(), account.toString());
            CoreHub.globalCfg.flush();
        }
    }

    private void addAccountId(String id) {
        if (id.contains(ACCOUNTS_SEPARATOR)) {
            throw new IllegalStateException("Id can not contain separator [,]");
        }
        String accountIds = CoreHub.globalCfg.get(CONFIG_ACCOUNTS, null);
        if (accountIds == null) {
            CoreHub.globalCfg.set(CONFIG_ACCOUNTS, id);
        } else {
            String[] currentIds;
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals(id)) {
                    return;
                }
                ++n2;
            }
            CoreHub.globalCfg.set(CONFIG_ACCOUNTS, String.valueOf(accountIds) + ACCOUNTS_SEPARATOR + id);
            CoreHub.globalCfg.flush();
        }
    }

    @Override
    public void removeAccount(MailAccount account) {
        if (account != null && account.getId() != null) {
            this.removeAccountId(account.getId());
            CoreHub.globalCfg.remove("ch.elexis.core.mail/account/" + account.getId());
            CoreHub.globalCfg.flush();
        }
    }

    private void removeAccountId(String id) {
        String accountIds = CoreHub.globalCfg.get(CONFIG_ACCOUNTS, null);
        if (accountIds != null) {
            String[] currentIds;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = currentIds = accountIds.split(ACCOUNTS_SEPARATOR);
            int n = currentIds.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!string.equals(id)) {
                    if (sb.length() > 0) {
                        sb.append(ACCOUNTS_SEPARATOR);
                    }
                    sb.append(string);
                }
                ++n2;
            }
            CoreHub.globalCfg.set(CONFIG_ACCOUNTS, sb.toString());
            CoreHub.globalCfg.flush();
        }
    }

    @Override
    public boolean testAccount(final MailAccount account) {
        block4: {
            MailClientProperties properties = new MailClientProperties(account);
            try {
                if (account.getType() == MailAccount.TYPE.SMTP) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    Transport transport = session.getTransport();
                    transport.connect();
                    transport.close();
                    break block4;
                }
                if (account.getType() == MailAccount.TYPE.IMAP) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    Store store = session.getStore("imaps");
                    store.connect();
                    store.close();
                    break block4;
                }
                logger.warn("Unknown account type [" + (Object)((Object)account.getType()) + "].");
                this.lastError = IMailClient.ErrorTyp.CONFIGTYP;
                return false;
            }
            catch (MessagingException e) {
                logger.warn("Error testing account [" + account.getId() + "]", (Throwable)e);
                this.handleException(e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean sendMail(final MailAccount account, MailMessage message) {
        block5: {
            MailClientProperties properties = new MailClientProperties(account);
            try {
                if (account.getType() == MailAccount.TYPE.SMTP) {
                    Session session = Session.getInstance((Properties)properties.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(account.getUsername(), account.getPassword());
                        }
                    });
                    MimeMessage mimeMessage = new MimeMessage(session);
                    mimeMessage.addHeader("X-ElexisMail", "ch.elexis.core.mail");
                    mimeMessage.setFrom(account.getFromAddress());
                    mimeMessage.setSubject(message.getSubject());
                    MimeMultipart multipart = new MimeMultipart();
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setText(message.getText());
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    if (message.hasAttachments()) {
                        List<File> attachments = message.getAttachments();
                        for (File file : attachments) {
                            messageBodyPart = new MimeBodyPart();
                            FileDataSource source = new FileDataSource(file);
                            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                            messageBodyPart.setFileName(file.getName());
                            multipart.addBodyPart((BodyPart)messageBodyPart);
                        }
                    }
                    mimeMessage.setContent((Multipart)multipart);
                    Transport transport = session.getTransport();
                    transport.connect();
                    transport.sendMessage((Message)mimeMessage, (Address[])message.getToAddress());
                    transport.close();
                    break block5;
                }
                logger.warn("Invalid account type for sending [" + (Object)((Object)account.getType()) + "].");
                this.lastError = IMailClient.ErrorTyp.CONFIGTYP;
                return false;
            }
            catch (MessagingException e) {
                logger.warn("Error sending using account [" + account.getId() + "]", (Throwable)e);
                this.handleException(e);
                return false;
            }
        }
        return true;
    }

    private void handleException(MessagingException e) {
        if (e instanceof AuthenticationFailedException) {
            this.lastError = IMailClient.ErrorTyp.AUTHENTICATION;
        } else if (e.getNextException() instanceof UnknownHostException) {
            this.lastError = IMailClient.ErrorTyp.CONNECTION;
        } else if (e instanceof AddressException) {
            this.lastError = IMailClient.ErrorTyp.ADDRESS;
        }
    }
}

