/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.dialogs.SendMailDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SendMailHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String text;
        String subject;
        String to;
        SendMailDialog sendMailDialog = new SendMailDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        String attachments = event.getParameter("ch.elexis.core.mail.ui.sendMail.attachments");
        if (attachments != null) {
            sendMailDialog.setAttachments(attachments);
        }
        if ((to = event.getParameter("ch.elexis.core.mail.ui.sendMail.to")) != null) {
            sendMailDialog.setTo(to);
        }
        if ((subject = event.getParameter("ch.elexis.core.mail.ui.sendMail.subject")) != null) {
            sendMailDialog.setSubject(subject);
        }
        if ((text = event.getParameter("ch.elexis.core.mail.ui.sendMail.text")) != null) {
            sendMailDialog.setText(text);
        }
        if (sendMailDialog.open() == 0) {
            MailMessage message = new MailMessage().to(sendMailDialog.getTo()).subject(sendMailDialog.getSubject()).text(sendMailDialog.getText());
            if (attachments != null && !attachments.isEmpty()) {
                List<File> attachmentList = this.getAttachmentsList(attachments);
                for (File file : attachmentList) {
                    message.addAttachment(file);
                }
            }
            Display display = Display.getDefault();
            try {
                MailSendRunnable mailSendRunnable = new MailSendRunnable(display, sendMailDialog, message, event);
                new ProgressMonitorDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)).run(false, false, (IRunnableWithProgress)mailSendRunnable);
                return mailSendRunnable.isSuccess();
            }
            catch (InterruptedException | InvocationTargetException e) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Versenden konnte nicht gestartet werden.");
            }
        }
        return false;
    }

    private List<File> getAttachmentsList(String attachments) {
        ArrayList<File> ret = new ArrayList<File>();
        if (attachments != null && !attachments.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = attachments.split(":::");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(new File(string));
                ++n2;
            }
        }
        return ret;
    }

    class MailSendRunnable
    implements IRunnableWithProgress {
        private final Display display;
        private final SendMailDialog sendMailDialog;
        private final ExecutionEvent event;
        private final MailMessage message;
        private boolean success;

        public MailSendRunnable(Display display, SendMailDialog sendMailDialog, MailMessage message, ExecutionEvent event) {
            this.display = display;
            this.sendMailDialog = sendMailDialog;
            this.event = event;
            this.message = message;
            this.success = false;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Send Mail ...", -1);
            if (MailClientComponent.getMailClient().sendMail(this.sendMailDialog.getAccount(), this.message)) {
                this.success = true;
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)MailSendRunnable.this.event), (String)"E-Mail versand", (String)"E-Mail erfolgreich versendet.");
                    }
                });
            } else {
                this.success = false;
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String errorMessage = MailClientComponent.getLastErrorMessage();
                        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)MailSendRunnable.this.event), (String)"Fehler", (String)errorMessage);
                    }
                });
            }
            monitor.done();
        }
    }
}

