/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.core.mail.ui.dialogs.MailAddressContentProposalProvider;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SendMailDialog
extends TitleAreaDialog {
    private ComboViewer accountsViewer;
    private MailAccount account;
    private Text toText;
    private String toString = "";
    private Text subjectText;
    private String subjectString = "";
    private Text textText;
    private String textString = "";
    private Label attachmentsLabel;
    private String attachmentsString = "";

    public SendMailDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        if (MailClientComponent.getMailClient() != null) {
            this.setTitle("E-Mail versenden");
        } else {
            this.setTitle("E-Mail versand nicht m\u00f6glich");
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        if (MailClientComponent.getMailClient() != null) {
            Label lbl = new Label(container, 0);
            lbl.setText("Konto");
            this.accountsViewer = new ComboViewer(container);
            this.accountsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.accountsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.accountsViewer.setInput(this.getSendMailAccounts());
            this.accountsViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lbl = new Label(container, 0);
            lbl.setText("An");
            this.toText = new Text(container, 2048);
            this.toText.setText(this.toString);
            this.toText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ContentProposalAdapter toAddressProposalAdapter = new ContentProposalAdapter((Control)this.toText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new MailAddressContentProposalProvider(), null, null);
            toAddressProposalAdapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    int index = MailAddressContentProposalProvider.getLastAddressIndex(SendMailDialog.this.toText.getText());
                    StringBuilder sb = new StringBuilder();
                    if (index != 0) {
                        sb.append(SendMailDialog.this.toText.getText().substring(0, index)).append(", ").append(proposal.getContent());
                    } else {
                        sb.append(proposal.getContent());
                    }
                    SendMailDialog.this.toText.setText(sb.toString());
                    SendMailDialog.this.toText.setSelection(SendMailDialog.this.toText.getText().length());
                }
            });
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action("email von"){

                public void run() {
                    KontaktSelektor selector = new KontaktSelektor(SendMailDialog.this.getShell(), Kontakt.class, "Kontakt auswahl", "Kontakt f\u00fcr die E-Mail Adresse ausw\u00e4hlen", Kontakt.DEFAULT_SORT);
                    if (selector.open() == 0) {
                        Kontakt selected = (Kontakt)selector.getSelection();
                        selected.set("E-Mail", SendMailDialog.this.toText.getSelectionText());
                    }
                }

                public boolean isEnabled() {
                    String text = SendMailDialog.this.toText.getSelectionText();
                    return text != null && !text.isEmpty() && text.contains("@");
                }
            });
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    IContributionItem[] items;
                    IContributionItem[] iContributionItemArray = items = manager.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem iContributionItem = iContributionItemArray[n2];
                        iContributionItem.update();
                        ++n2;
                    }
                }
            });
            this.toText.setMenu(menuManager.createContextMenu((Control)this.toText));
            lbl = new Label(container, 0);
            lbl.setText("Betreff");
            this.subjectText = new Text(container, 2048);
            this.subjectText.setText(this.subjectString);
            this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lbl = new Label(container, 0);
            lbl.setText("Anhang");
            this.attachmentsLabel = new Label(container, 0);
            this.attachmentsLabel.setToolTipText(this.attachmentsString);
            this.attachmentsLabel.setText(this.getAttachmentNames(this.attachmentsString));
            this.attachmentsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lbl = new Label(container, 0);
            lbl.setText("Text");
            this.textText = new Text(container, 2050);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 128;
            this.textText.setLayoutData((Object)gd);
            Mandant selectedMandant = ElexisEventDispatcher.getSelectedMandator();
            if (selectedMandant != null) {
                List accounts = MailClientComponent.getMailClient().getAccounts();
                for (String string : accounts) {
                    Optional accountOptional = MailClientComponent.getMailClient().getAccount(string);
                    if (!accountOptional.isPresent() || !((MailAccount)accountOptional.get()).isForMandant(selectedMandant.getId())) continue;
                    this.accountsViewer.setSelection((ISelection)new StructuredSelection((Object)((MailAccount)accountOptional.get()).getId()));
                }
            }
        }
        return area;
    }

    public String getAttachmentNames(String attachmentAsString) {
        StringBuilder build = new StringBuilder();
        if (attachmentAsString != null) {
            String[] attachments;
            String[] stringArray = attachments = attachmentAsString.split(",\n");
            int n = attachments.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (build.length() > 0) {
                    build.append(",\n");
                }
                build.append(Paths.get(f, new String[0]).getFileName());
                ++n2;
            }
        }
        return build.toString();
    }

    public void setAttachments(String attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            this.attachmentsString = attachments.replaceAll(":::", ",\n");
        }
    }

    public void setTo(String to) {
        if (to != null && !to.isEmpty()) {
            this.toString = to;
        }
    }

    public void setSubject(String subject) {
        if (subject != null && !subject.isEmpty()) {
            this.subjectString = subject;
        }
    }

    public void setText(String text) {
        if (text != null && !text.isEmpty()) {
            this.textString = text;
        }
    }

    private List<String> getSendMailAccounts() {
        ArrayList<String> ret = new ArrayList<String>();
        List accounts = MailClientComponent.getMailClient().getAccounts();
        for (String accountId : accounts) {
            Optional accountOptional = MailClientComponent.getMailClient().getAccount(accountId);
            if (!accountOptional.isPresent() || ((MailAccount)accountOptional.get()).getType() != MailAccount.TYPE.SMTP) continue;
            ret.add(accountId);
        }
        return ret;
    }

    protected void okPressed() {
        String validation = this.getValidation();
        if (validation != null) {
            this.setErrorMessage(validation);
            return;
        }
        super.okPressed();
    }

    private String getValidation() {
        StructuredSelection accountSelection = (StructuredSelection)this.accountsViewer.getSelection();
        if (accountSelection == null || accountSelection.isEmpty()) {
            return "Kein Konto ausgew\u00e4hlt.";
        }
        String accountId = (String)accountSelection.getFirstElement();
        Optional optionalAccount = MailClientComponent.getMailClient().getAccount(accountId);
        if (!optionalAccount.isPresent()) {
            return "Kein Konto ausgew\u00e4hlt.";
        }
        this.account = (MailAccount)optionalAccount.get();
        String to = this.toText.getText();
        if (to == null || to.isEmpty()) {
            return "Keine an E-Mail Adresse.";
        }
        this.toString = to;
        this.subjectString = this.subjectText.getText();
        this.textString = this.textText.getText();
        return null;
    }

    public String getTo() {
        return this.toString;
    }

    public String getSubject() {
        return this.subjectString;
    }

    public String getText() {
        return this.textString;
    }

    public MailAccount getAccount() {
        return this.account;
    }
}

