/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.client;

import ch.elexis.core.mail.IMailClient;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class MailClientComponent {
    private static IMailClient mailClient;

    @Reference
    public void setMailClient(IMailClient mailClient) {
        MailClientComponent.mailClient = mailClient;
    }

    public void unsetMailClient(IMailClient mailClient) {
        MailClientComponent.mailClient = null;
    }

    public static IMailClient getMailClient() {
        return mailClient;
    }

    public static String getLastErrorMessage() {
        Optional error;
        String message = "Kein Fehler";
        if (mailClient != null && (error = mailClient.getLastError()).isPresent()) {
            switch ((IMailClient.ErrorTyp)error.get()) {
                case AUTHENTICATION: {
                    message = "Fehler bei der Authorisation. Bitte Anmeldedaten \u00fcberpr\u00fcfen.";
                    break;
                }
                case CONFIGTYP: {
                    message = "Fehler bei der Konfiguration. Bitte Account Typ \u00fcberpr\u00fcfen.";
                    break;
                }
                case CONNECTION: {
                    message = "Fehler bei der Verbindung. Bitte Verbindungsdaten \u00fcberpr\u00fcfen.";
                    break;
                }
                case ADDRESS: {
                    message = "Fehler bei der Adresse. Bitte Username \u00fcberpr\u00fcfen.";
                }
            }
        }
        return message;
    }
}

