/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.logging.osgi;

import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class OsgiSl4fjLoggingAdapter
implements LogListener {
    private Logger logger = LoggerFactory.getLogger((String)"OSGI");

    @Reference
    public void bindLogReaderService(LogReaderService logReaderService) {
        logReaderService.addLogListener((LogListener)this);
    }

    public void unbindLogReaderService(LogReaderService logReaderService) {
        logReaderService.removeLogListener((LogListener)this);
    }

    public void logged(LogEntry entry) {
        Bundle bundle = entry.getBundle();
        String message = bundle != null ? "[" + bundle.getSymbolicName() + "] " + entry.getMessage() : entry.getMessage();
        Throwable exception = entry.getException();
        switch (entry.getLevel()) {
            case 1: {
                this.logger.error(message, exception);
                break;
            }
            case 2: {
                this.logger.warn(message, exception);
                break;
            }
            case 3: {
                this.logger.info(message, exception);
                break;
            }
            default: {
                this.logger.debug(message, exception);
            }
        }
    }
}

