/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile.strategy;

import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.multifile.strategy.FileImportStrategyUtil;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.model.ILabResult;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DefaultHL7ImportStrategy
implements IFileImportStrategy {
    private boolean testMode;
    private boolean moveAfterImport;
    private ILabContactResolver labContactResolver;
    public static final String CFG_IMPORT_ENCDATA = "hl7Parser/importencdata";

    @Override
    public Result<Object> execute(File file, Map<String, Object> context, HL7Parser hl7Parser, IPersistenceHandler persistenceHandler) throws IOException {
        List<ILabOrder> orders;
        Object resultObj;
        String myLab = (String)context.get("labname");
        Result<?> result = null;
        if (this.testMode) {
            result = this.labContactResolver != null ? hl7Parser.importFile(file, null, null, this.labContactResolver, true) : hl7Parser.importFile(file.getAbsolutePath(), true);
            if (this.moveAfterImport) {
                FileImportStrategyUtil.moveAfterImport(result.isOK(), file);
            }
        } else {
            result = this.labContactResolver != null ? hl7Parser.importFile(file, null, null, this.labContactResolver, false) : hl7Parser.importFile(file.getAbsolutePath(), false);
            if (this.moveAfterImport) {
                FileImportStrategyUtil.moveAfterImport(result.isOK(), file);
            }
        }
        if ((resultObj = result.get()) instanceof String && (orders = persistenceHandler.getLabOrdersByOrderId((String)resultObj)) != null && !orders.isEmpty()) {
            ILabOrder order = orders.get(0);
            context.put("patient", order.getPatientContact());
            context.put("labid", order.getLabResult().getOriginContact().getId());
            context.put("group", order.getLabItem().getGroup());
            context.put("prio", order.getLabItem().getPriority());
            context.put("time", this.getDate(order.getLabResult()));
        }
        return result;
    }

    private TimeTool getDate(ILabResult result) {
        TimeTool observationTime = result.getObservationTime();
        if (observationTime == null) {
            return new TimeTool(result.getDate());
        }
        return observationTime;
    }

    @Override
    public void setTestMode(boolean testing) {
        this.testMode = testing;
    }

    @Override
    public IFileImportStrategy setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }

    @Override
    public IFileImportStrategy setLabContactResolver(ILabContactResolver resolver) {
        this.labContactResolver = resolver;
        return this;
    }
}

