/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile.strategy;

import ch.elexis.core.importer.div.importers.multifile.strategy.DefaultHL7ImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.rgw.io.FileTool;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicFileImportStrategyFactory
implements IFileImportStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(BasicFileImportStrategyFactory.class);

    @Override
    public Map<File, IFileImportStrategy> createImportStrategyMap(File hl7File) {
        HashMap<File, IFileImportStrategy> ret = new HashMap<File, IFileImportStrategy>();
        if (!this.validateHL7File(hl7File)) {
            throw new IllegalStateException("File [" + hl7File + "] is not a processable HL7 File");
        }
        ret.put(hl7File, new DefaultHL7ImportStrategy());
        return ret;
    }

    protected List<File> getMatchingFiles(File hl7File) {
        ArrayList<File> matchingFiles = new ArrayList<File>();
        String origin = hl7File.getName();
        String seekName = FileTool.getNakedFilename((String)origin);
        File directory = hl7File.getParentFile();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (name.startsWith(seekName) && !name.equals(origin)) {
                matchingFiles.add(f);
            }
            ++n2;
        }
        log.debug("Found " + matchingFiles.size() + " matching files for HL7File [" + hl7File.getName() + "]");
        return matchingFiles;
    }

    protected boolean validateHL7File(File hl7File) {
        if (hl7File == null || !hl7File.exists()) {
            return false;
        }
        return hl7File.getName().toLowerCase().endsWith("hl7");
    }
}

