/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.importers.multifile;

import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.Messages;
import ch.elexis.core.importer.div.importers.multifile.IMultiFileParser;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.rgw.io.FileTool;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class MultiFileParser
implements IMultiFileParser {
    private boolean testMode = false;
    private String myLab;

    public MultiFileParser(String myLab) {
        this.myLab = myLab;
    }

    @Override
    public Result<Object> importFromFile(File hl7File, IFileImportStrategyFactory importStrategyFactory, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("labname", this.myLab);
        Map<File, IFileImportStrategy> strategyMap = null;
        try {
            strategyMap = importStrategyFactory.createImportStrategyMap(hl7File);
        }
        catch (IllegalStateException ise) {
            return new Result(Result.SEVERITY.ERROR, 1, Messages.MultiFileParser_InvalidFile, (Object)hl7File, true);
        }
        List<File> keys = this.sortStrategyList(hl7File, strategyMap);
        Result results = new Result();
        for (File file : keys) {
            IFileImportStrategy importStrategy = strategyMap.get(file);
            importStrategy.setTestMode(this.testMode);
            try {
                results.add(importStrategy.execute(file, context, hl7parser, persistenceHandler));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error executing import", (Throwable)e);
            }
        }
        return results;
    }

    @Override
    public Result<Object> importFromDirectory(File directory, IFileImportStrategyFactory importStrategyFactory, HL7Parser hl7parser, IPersistenceHandler persistenceHandler) {
        Result results = new Result();
        File[] fileArray = this.sortListFiles(directory.listFiles());
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String extension = FileTool.getExtension((String)file.getName()).toLowerCase();
            if (extension.equals("hl7")) {
                results.add(this.importFromFile(file, importStrategyFactory, hl7parser, persistenceHandler));
            }
            ++n2;
        }
        return results;
    }

    private List<File> sortStrategyList(File hl7File, Map<File, IFileImportStrategy> strategyMap) {
        ArrayList<File> keys = new ArrayList<File>(strategyMap.keySet());
        keys.remove(hl7File);
        keys.add(0, hl7File);
        return keys;
    }

    public void setTestMode(boolean testing) {
        this.testMode = true;
    }

    public boolean inTestMode() {
        return this.testMode;
    }

    protected File[] sortListFiles(File[] files) {
        return files;
    }
}

