/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.v2x;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.FT;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TX;
import ca.uhn.hl7v2.model.v22.group.ORU_R01_OBSERVATION;
import ca.uhn.hl7v2.model.v22.group.ORU_R01_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v22.group.ORU_R01_PATIENT;
import ca.uhn.hl7v2.model.v22.group.ORU_R01_PATIENT_RESULT;
import ca.uhn.hl7v2.model.v22.message.ORU_R01;
import ca.uhn.hl7v2.model.v22.segment.MSH;
import ca.uhn.hl7v2.model.v22.segment.NTE;
import ca.uhn.hl7v2.model.v22.segment.OBR;
import ca.uhn.hl7v2.model.v22.segment.OBX;
import ca.uhn.hl7v2.model.v22.segment.ORC;
import ca.uhn.hl7v2.model.v22.segment.PID;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.hl7.HL7PatientResolver;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.model.LabResultData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.model.OrcMessage;
import ch.elexis.hl7.model.TextData;
import ch.rgw.tools.StringTool;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ReaderV22
extends HL7Reader {
    static Logger logger = LoggerFactory.getLogger(HL7ReaderV22.class);

    public HL7ReaderV22(Message message) {
        super(message);
    }

    @Override
    public String getSender() throws ElexisException {
        String sender = "";
        try {
            MSH msh = (MSH)this.message.get("MSH");
            sender = msh.getMsh4_SendingFacility().getValue();
            if (sender == null) {
                sender = "";
            }
        }
        catch (HL7Exception e) {
            throw new ElexisException(e.getMessage(), (Throwable)e);
        }
        return sender;
    }

    @Override
    public ObservationMessage readObservation(HL7PatientResolver patientResolver, boolean createIfNotFound) throws ElexisException {
        this.observation = null;
        ORU_R01 oru = (ORU_R01)this.message;
        try {
            this.patientResolver = patientResolver;
            this.setPatient(oru, createIfNotFound);
            int obsCount = oru.getPATIENT_RESULT().getORDER_OBSERVATIONReps();
            int idx = 0;
            while (idx < obsCount) {
                OBR obr = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBR();
                String obrObservationDateTime = obr.getObr7_ObservationDateTime().getTs1_TimeOfAnEvent().getValue();
                this.setOrderComment(oru, idx, obrObservationDateTime);
                int i = 0;
                while (i < oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx).getOBSERVATIONReps()) {
                    ORU_R01_ORDER_OBSERVATION obs = oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx);
                    String commentNTE = this.getComments(obs, i);
                    String group = "";
                    String sequence = "";
                    int k = 0;
                    while (k < 2) {
                        CE ce = obr.getUniversalServiceID();
                        if (ce != null) {
                            String code = "";
                            if (ce.getCe3_NameOfCodingSystem() != null) {
                                code = ce.getCe3_NameOfCodingSystem().getValue();
                            }
                            group = this.getGroup(code, ce);
                            sequence = this.getSequence(code, ce);
                        }
                        ++k;
                    }
                    this.readOBXResults(obs.getOBSERVATION(i), commentNTE, group, sequence, obrObservationDateTime);
                    ++i;
                }
                ++idx;
            }
        }
        catch (HL7Exception | ParseException e) {
            throw new ElexisException(e.getMessage(), e);
        }
        return this.observation;
    }

    private String getGroup(String code, CE ce) {
        if ("99DGC".equalsIgnoreCase(code) && ce.getCe2_Text() != null) {
            return ce.getCe2_Text().getValue();
        }
        return "";
    }

    private String getSequence(String code, CE ce) {
        if ("99DGP".equalsIgnoreCase(code) && ce.getCe1_Identifier() != null) {
            return ce.getCe1_Identifier().getValue();
        }
        return "";
    }

    private void setPatient(ORU_R01 oru, boolean createIfNotFound) throws ParseException, HL7Exception {
        List<Object> list = new ArrayList();
        String lastName = "";
        String firstName = "";
        String birthDate = "";
        String sex = Gender.FEMALE.value();
        this.pat = null;
        if (this.pat == null) {
            String sendingApplication = oru.getMSH().getMsh3_SendingApplication().getValue();
            String sendingFacility = oru.getMSH().getMsh4_SendingFacility().getValue();
            String dateTimeOfMessage = oru.getMSH().getMsh7_DateTimeOfMessage().getTs1_TimeOfAnEvent().getValue();
            PID pid = oru.getPATIENT_RESULT().getPATIENT().getPID();
            String patid = pid.getPatientIDInternalID(0).getCm_pat_id1_IDNumber().getValue();
            String patid_alternative = pid.getAlternatePatientID().getValue();
            if (StringTool.isNothing((Object)patid) && StringTool.isNothing((Object)(patid = pid.getPatientIDExternalID().getCk1_IDNumber().getValue())) && (patid = patid_alternative) == null) {
                patid = "";
            }
            if (patid != null) {
                list = this.patientResolver.getPatientById(patid);
            }
            String orderNumber = oru.getPATIENT_RESULT().getORDER_OBSERVATION().getORC().getOrc2_PlacerOrderNumber().getCm_placer1_UniquePlacerId().getValue();
            if (pid.getPatientName().getPn1_FamilyName().getValue() != null) {
                lastName = pid.getPatientName().getPn1_FamilyName().getValue();
            }
            if (pid.getPatientName().getGivenName().getValue() != null) {
                firstName = pid.getPatientName().getGivenName().getValue();
            }
            String patientName = String.valueOf(firstName) + " " + lastName;
            String patientNotesAndComments = this.readPatientNotesAndComments(oru.getPATIENT_RESULT().getPATIENT());
            this.observation = new ObservationMessage(sendingApplication, sendingFacility, dateTimeOfMessage, patid, patientName, patientNotesAndComments, patid_alternative, orderNumber);
            birthDate = pid.getDateOfBirth().getTs1_TimeOfAnEvent().getValue();
            sex = pid.getSex().getValue();
            if (patid == null || list.size() != 1) {
                list = this.patientResolver.findPatientByNameAndBirthdate(lastName, firstName, birthDate);
                if (list != null && list.size() == 1) {
                    this.pat = (IPatient)list.get(0);
                } else if (createIfNotFound) {
                    String phone = "";
                    AD adr = pid.getPatientAddress(0);
                    phone = pid.getPhoneNumberHome(0).getValue();
                    this.pat = this.patientResolver.createPatient(lastName, firstName, birthDate, sex);
                    this.pat.setPatientNr(patid);
                    if (adr != null) {
                        if (adr.getStreetAddress().getValue() != null) {
                            this.pat.setStreet(adr.getStreetAddress().getValue());
                        }
                        if (adr.getZipOrPostalCode().getValue() != null) {
                            this.pat.setZip(adr.getZipOrPostalCode().getValue());
                        }
                        if (adr.getCity().getValue() != null) {
                            this.pat.setCity(adr.getCity().getValue());
                        }
                        if (adr.getCountry().getValue() != null) {
                            Country cc = Country.valueOf((String)adr.getAd6_Country().getValue());
                            this.pat.setCountry(cc);
                        }
                    }
                    this.pat.setPhone1(phone);
                } else {
                    this.resolvePatient(firstName, lastName, birthDate);
                }
            } else {
                this.pat = (IPatient)list.get(0);
                if (lastName.length() != 0 && firstName.length() != 0) {
                    this.checkConflict(firstName, lastName, birthDate, sex);
                }
            }
        }
    }

    private void setOrderComment(ORU_R01 oru, int idx, String obsDate) throws ParseException {
        String orderCommentNTE = this.getComments(oru.getPATIENT_RESULT().getORDER_OBSERVATION(idx), -1);
        if (orderCommentNTE != null) {
            this.observation.add(new TextData("Kommentar", orderCommentNTE, obsDate, "00 Kommentar", null));
        }
    }

    private String getComments(ORU_R01_ORDER_OBSERVATION oobs, int i) {
        String commentNTE = null;
        int size = oobs.getNTEReps();
        if (i > -1) {
            size = oobs.getOBSERVATION(i).getNTEReps();
        }
        int n = 0;
        while (n < size) {
            FT comment;
            NTE nte = oobs.getNTE(n);
            if (i > -1) {
                nte = oobs.getOBSERVATION(i).getNTE(n);
            }
            if ((comment = nte.getNte3_Comment(0)) != null) {
                commentNTE = commentNTE != null ? String.valueOf(commentNTE) + "\n" : "";
                if (comment.getValue() != null) {
                    commentNTE = String.valueOf(commentNTE) + comment.getValue();
                }
            }
            ++n;
        }
        return commentNTE;
    }

    private void readOBXResults(ORU_R01_OBSERVATION obs, String commentNTE, String group, String sequence, String defaultDateTime) throws ParseException {
        OBX obx = obs.getOBX();
        String valueType = obx.getObx2_ValueType().getValue();
        String name = "";
        String itemCode = "";
        String unit = "";
        String range = "";
        String observationTime = "";
        String status = "";
        if (this.isTextOrNumeric(valueType)) {
            name = obx.getObx3_ObservationIdentifier().getCe2_Text().getValue();
            if (name == null) {
                name = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
            }
            String value = "";
            Type tmp = obx.getObx5_ObservationValue().getData();
            if (tmp instanceof ST) {
                value = ((ST)tmp).getValue();
            } else if (tmp instanceof TX) {
                value = ((TX)tmp).getValue();
                if (value.contains("\\.br")) {
                    value = this.parseTextValue(value);
                }
            } else if (tmp instanceof FT) {
                value = this.parseFormattedTextValue(((FT)tmp).getValue());
            } else if (tmp instanceof NM) {
                value = ((NM)tmp).getValue();
            } else if (tmp instanceof CE) {
                value = ((CE)tmp).getCe2_Text().getValue();
            }
            itemCode = obx.getObx3_ObservationIdentifier().getCe1_Identifier().getValue();
            unit = obx.getObx6_Units().getCe1_Identifier().getValue();
            range = obx.getObx7_ReferencesRange().getValue();
            String rawAbnormalFlags = obx.getObx8_AbnormalFlags(0).getValue();
            Boolean flag = this.isPathologic(rawAbnormalFlags);
            observationTime = obx.getObx14_DateTimeOfTheObservation().getTs1_TimeOfAnEvent().getValue();
            status = obx.getObx11_ObservationResultStatus().getValue();
            LabResultData lrd = new LabResultData(itemCode, name, unit, value, range, flag, rawAbnormalFlags, defaultDateTime, observationTime, commentNTE, group, sequence, status, this.extractName((Primitive)obx.getObx4_ObservationSubID()));
            if (valueType.equals("NM")) {
                lrd.setIsNumeric(true);
            } else if (valueType.equals("TX")) {
                lrd.setIsPlainText(true);
            } else if (valueType.equals("FT")) {
                lrd.setIsFormatedText(true);
            }
            this.observation.add(lrd);
        } else {
            logger.error(MessageFormat.format("Value type {0} is not implemented!", valueType));
        }
    }

    private String readPatientNotesAndComments(ORU_R01_PATIENT patient) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < patient.getNTEReps()) {
            FT comment = patient.getNTE(i).getComment(0);
            sb.append(comment.toString());
            if (patient.getNTEReps() > i) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public OrcMessage getOrcMessage() {
        try {
            ORU_R01_ORDER_OBSERVATION oo;
            ORU_R01_PATIENT_RESULT pr;
            ORU_R01 oru = (ORU_R01)this.message;
            if (oru != null && (pr = oru.getPATIENT_RESULT()) != null && (oo = pr.getORDER_OBSERVATION()) != null) {
                return this.extractOrc(oo.getORC());
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(HL7Reader.class).warn("orc parsing failed", (Throwable)e);
        }
        return null;
    }

    private OrcMessage extractOrc(ORC orc) throws HL7Exception {
        if (orc != null) {
            OrcMessage orcMessage = new OrcMessage();
            CN ops = orc.getOrderingProvider();
            this.addNameValuesToOrcMessage((Primitive)ops.getFamilyName(), (Primitive)ops.getGivenName(), orcMessage);
            return orcMessage;
        }
        return null;
    }
}

