/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class HL7Helper {
    private static final String DTM_DATE_TIME_PATTERN = "yyyyMMddHHmmss";

    public static Date stringToDate(String dateTimeStr) throws ParseException {
        if (dateTimeStr == null || dateTimeStr.length() == 0) {
            return null;
        }
        if (dateTimeStr.length() >= 14) {
            SimpleDateFormat sdf = new SimpleDateFormat(DTM_DATE_TIME_PATTERN.substring(0, 14));
            return sdf.parse(dateTimeStr);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DTM_DATE_TIME_PATTERN.substring(0, dateTimeStr.length()));
        return sdf.parse(dateTimeStr);
    }

    public static String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        String pattern = DTM_DATE_TIME_PATTERN;
        if (cal.get(13) == 0) {
            pattern.substring(0, pattern.length() - 2);
        }
        if (cal.get(12) == 0) {
            pattern.substring(0, pattern.length() - 2);
        }
        if (cal.get(10) == 0) {
            pattern.substring(0, pattern.length() - 2);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(cal.getTime());
    }

    public static String dateToString(LocalDateTime localDateTime) {
        return HL7Helper.dateToString(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    public static String determineName(List<String> possibleNames) {
        String ret = "";
        for (String possibleName : possibleNames) {
            int retNonDigitCount;
            int possibleNonDigitCount;
            if (possibleName == null || "null".equals(possibleName) || (possibleNonDigitCount = HL7Helper.getNonDigitCharacters(possibleName)) <= (retNonDigitCount = HL7Helper.getNonDigitCharacters(ret))) continue;
            ret = possibleName;
        }
        return ret;
    }

    private static int getNonDigitCharacters(String possibleName) {
        int ret = possibleName.length();
        int i = 0;
        int len = possibleName.length();
        while (i < len) {
            if (Character.isDigit(possibleName.charAt(i))) {
                --ret;
            }
            ++i;
        }
        return ret;
    }
}

