/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ch.elexis.core.findings.util.ModelUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;

public abstract class AbstractFindingsAccessor {
    public Optional<String> getText(DomainResource resource) {
        Narrative narrative = resource.getText();
        if (narrative != null && narrative.getDivAsString() != null) {
            return ModelUtil.getNarrativeAsString(narrative);
        }
        return Optional.empty();
    }

    public void setText(DomainResource resource, String text) {
        Narrative narrative = resource.getText();
        if (narrative == null) {
            narrative = new Narrative();
        }
        ModelUtil.setNarrativeFromString(narrative, text);
        resource.setText(narrative);
    }

    public void addStringExtension(DomainResource resource, String theUrl, String theValue) {
        Extension extension = new Extension(theUrl);
        extension.setValue((Type)new StringType().setValue((Object)theValue));
        resource.addExtension(extension);
    }

    public Map<String, String> getStringExtensions(DomainResource resource) {
        List extensions = resource.getExtension();
        return extensions.stream().filter(extension -> extension.getValue() instanceof StringType).collect(Collectors.toMap(extension -> extension.getUrl(), extension -> ((StringType)extension.getValue()).getValueAsString()));
    }

    protected Date getDate(LocalDateTime localDateTime) {
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    protected Date getDate(LocalDate localDate) {
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    protected LocalDateTime getLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    protected LocalDate getLocalDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }
}

