/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views.nattable;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.data.Patient;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class DynamicDataProvider
implements IDataProvider {
    private List<IFinding> currentFindings = new ArrayList<IFinding>();
    private List<ICoding> shownCodings;
    private List<LocalDateTime> shownDates;
    private HashMap<LocalDateTime, List<IFinding>[]> shownFindings = new HashMap();

    public DynamicDataProvider() {
        this.shownDates = new ArrayList<LocalDateTime>();
        this.shownCodings = new ArrayList<ICoding>();
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        List<IFinding>[] findings;
        if (rowIndex >= 0 && rowIndex < this.shownDates.size() && (findings = this.shownFindings.get(this.shownDates.get(rowIndex))) != null && columnIndex < findings.length && findings[columnIndex] != null) {
            return findings[columnIndex];
        }
        return null;
    }

    public int getRowCount() {
        return this.shownFindings.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    public int getColumnCount() {
        return this.shownCodings.size();
    }

    public void reload(Patient selectedPatient) {
        if (selectedPatient == null) {
            this.currentFindings.clear();
        } else {
            this.currentFindings = this.getFindings(selectedPatient);
        }
        this.updateShownFindings();
    }

    public List<IFinding> getFindings(Patient patient) {
        ArrayList<IFinding> ret = new ArrayList<IFinding>();
        if (patient != null && patient.exists()) {
            String patientId = patient.getId();
            ret.addAll(this.getObservations(patientId));
        }
        return ret;
    }

    private List<IObservation> getObservations(String patientId) {
        return FindingsServiceComponent.getService().getPatientsFindings(patientId, IObservation.class);
    }

    public void setShownCodings(List<ICoding> showCodings) {
        this.shownCodings = showCodings;
        this.updateShownFindings();
    }

    private void updateShownFindings() {
        this.shownFindings.clear();
        this.shownDates.clear();
        for (IFinding iFinding : this.currentFindings) {
            IObservation iObservation;
            int index;
            if (!(iFinding instanceof IObservation) || (index = this.getCodingIndex(iObservation = (IObservation)iFinding)) == -1) continue;
            LocalDateTime time = iObservation.getEffectiveTime().orElse(LocalDateTime.MIN);
            List<IFinding>[] findings = this.shownFindings.get(time);
            if (findings == null) {
                findings = new List[this.shownCodings.size()];
                this.shownDates.add(time);
            }
            if (findings[index] == null) {
                findings[index] = new ArrayList<IFinding>();
            }
            findings[index].add((IFinding)iObservation);
            this.shownFindings.put(time, findings);
        }
        Collections.sort(this.shownDates);
        Collections.reverse(this.shownDates);
    }

    private int getCodingIndex(IObservation iObservation) {
        for (ICoding iCoding : iObservation.getCoding()) {
            int i = 0;
            while (i < this.shownCodings.size()) {
                if (this.shownCodings.get(i).getCode().equals(iCoding.getCode())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List<LocalDateTime> getShownDates() {
        return this.shownDates;
    }
}

