/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.views.nattable;

import ch.elexis.core.findings.ui.views.nattable.NatTableWrapper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class DragAndDropSupport
implements DragSourceListener,
DropTargetListener {
    private static final String DATA_SEPARATOR = ",";
    private final NatTableWrapper tableWrapper;
    private List<Object> draggedObjects;
    PersistentObjectFactory factory = new PersistentObjectFactory();

    public DragAndDropSupport(NatTableWrapper tableWrapper) {
        this.tableWrapper = tableWrapper;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.tableWrapper.getSelection().isEmpty()) {
            event.doit = false;
        } else if (!this.tableWrapper.getNatTable().getRegionLabelsByXY(event.x, event.y).hasLabel("BODY")) {
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        StructuredSelection selection = (StructuredSelection)this.tableWrapper.getSelection();
        if (!selection.isEmpty()) {
            this.draggedObjects = new ArrayList<Object>(selection.toList());
            StringBuilder builder = new StringBuilder();
            for (Object object : this.draggedObjects) {
                if (builder.length() > 0) {
                    builder.append(DATA_SEPARATOR);
                }
                builder.append(this.getStringForObject(object));
            }
            event.data = builder.toString();
        }
    }

    private Object getStringForObject(Object object) {
        if (object instanceof PersistentObject) {
            return ((PersistentObject)object).storeToString();
        }
        return object.toString();
    }

    public void dragFinished(DragSourceEvent event) {
        this.draggedObjects = null;
        this.tableWrapper.getNatTable().refresh();
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        String[] data;
        String[] stringArray = data = event.data != null ? event.data.toString().split("\\,") : new String[]{};
        if (data.length > 0) {
            String[] stringArray2 = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                Object object = this.getObjectForString(data[0]);
                if (object != null) {
                    int rowPosition = this.getRowPosition(event);
                    int n3 = this.getColumnPosition(event);
                }
                ++n2;
            }
        }
    }

    private Object getObjectForString(String string) {
        if (string.contains("::")) {
            return this.factory.createFromString(string);
        }
        return null;
    }

    private int getColumnPosition(DropTargetEvent event) {
        Point pt = event.display.map(null, (Control)this.tableWrapper.getNatTable(), event.x, event.y);
        int position = this.tableWrapper.getNatTable().getColumnPositionByX(pt.x);
        return position;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private int getRowPosition(DropTargetEvent event) {
        Point pt = event.display.map(null, (Control)this.tableWrapper.getNatTable(), event.x, event.y);
        int position = this.tableWrapper.getNatTable().getRowPositionByY(pt.y);
        return position;
    }
}

