/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.viewcontributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.composites.RiskComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.data.Patient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RiskViewContribution
implements IViewContribution {
    RiskComposite riskComposite;

    public void setUnlocked(boolean unlocked) {
    }

    public String getLocalizedTitle() {
        return "Risiken";
    }

    public boolean isAvailable() {
        return CoreHub.globalCfg.get("riskfactor/settings/useStructured", false);
    }

    public Composite initComposite(Composite parent) {
        this.riskComposite = new RiskComposite(parent, 0);
        return this.riskComposite;
    }

    public void setDetailObject(Object detailObject, Object additionalData) {
        List observations = null;
        if (this.riskComposite != null) {
            if (FindingsServiceComponent.getService() != null && detailObject instanceof Patient) {
                observations = FindingsServiceComponent.getService().getPatientsFindings(((Patient)detailObject).getId(), IObservation.class);
                observations = observations.stream().filter(finding -> this.isRisk((IFinding)finding)).collect(Collectors.toList());
            }
            if (observations != null && observations.size() >= 1) {
                if (observations.size() > 1) {
                    MessageDialog.openWarning((Shell)this.riskComposite.getShell(), (String)"Risiken", (String)"Mehr als eine Risiken Eintr\u00e4ge gefunden.\n Nur der letzte Risiken Eintrag wird angezeigt.");
                }
                this.riskComposite.setInput(Optional.of((IObservation)observations.get(0)));
            } else {
                this.riskComposite.setInput(Optional.empty());
            }
        }
    }

    private boolean isRisk(IFinding iFinding) {
        if (iFinding instanceof IObservation && ((IObservation)iFinding).getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : ((IObservation)iFinding).getCoding()) {
                if (!IObservation.ObservationCode.ANAM_RISK.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }
}

