/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.viewcontributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.composites.DiagnoseListComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.data.Patient;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Composite;

public class PatientDetailViewContribution
implements IViewContribution {
    DiagnoseListComposite conditionsComposite;

    public void setUnlocked(boolean unlocked) {
    }

    public String getLocalizedTitle() {
        return "Diagnosen";
    }

    public boolean isAvailable() {
        return CoreHub.globalCfg.get("diagnose/settings/useStructured", false);
    }

    public Composite initComposite(Composite parent) {
        this.conditionsComposite = new DiagnoseListComposite(parent, 0);
        return this.conditionsComposite;
    }

    public void setDetailObject(Object detailObject, Object additionalData) {
        if (this.conditionsComposite != null && FindingsServiceComponent.getService() != null && detailObject instanceof Patient) {
            List<ICondition> conditions = FindingsServiceComponent.getService().getPatientsFindings(((Patient)detailObject).getId(), ICondition.class);
            conditions = conditions.stream().filter(finding -> this.isDiagnose((IFinding)finding)).collect(Collectors.toList());
            this.conditionsComposite.setInput(conditions);
        } else if (this.conditionsComposite != null) {
            this.conditionsComposite.setInput(Collections.emptyList());
        }
    }

    private boolean isDiagnose(IFinding iFinding) {
        return iFinding instanceof ICondition && ((ICondition)iFinding).getCategory() == ICondition.ConditionCategory.PROBLEMLISTITEM;
    }
}

