/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IClinicalImpression;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IProcedureRequest;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.ui.action.DateAction;
import ch.elexis.core.findings.ui.composites.CompositeGroup;
import ch.elexis.core.findings.ui.composites.ICompositeSaveable;
import ch.elexis.core.findings.ui.services.CodingServiceComponent;
import ch.elexis.core.findings.util.commands.FindingDeleteCommand;
import ch.elexis.core.findings.util.commands.ILockingProvider;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.CommentAction;
import ch.elexis.core.ui.util.SWTHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.LoggerFactory;

public class FindingsUiUtil {
    private static String CFG_VISIBLE_CODINGS = "ch.elexis.core.findings/ui/visiblecodings";
    private static String CFG_SELECTED_CODINGS = "ch.elexis.core.findings/ui/selectedcodings";

    public static List<ICoding> getAvailableCodings() {
        List codes = CodingServiceComponent.getService().getAvailableCodes(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        codes.sort((a, b) -> a.getDisplay().compareTo(b.getDisplay()));
        return codes;
    }

    public static List<ICoding> loadVisibleCodings() {
        String visibleCodingsString = CoreHub.mandantCfg.get(CFG_VISIBLE_CODINGS, null);
        List<ICoding> availableCodings = FindingsUiUtil.getAvailableCodings();
        if (visibleCodingsString != null) {
            String[] parts;
            ArrayList<ICoding> visible = new ArrayList<ICoding>();
            String[] stringArray = parts = visibleCodingsString.split("\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                for (ICoding availableCoding : availableCodings) {
                    if (!availableCoding.getCode().equals(part)) continue;
                    visible.add(availableCoding);
                    break;
                }
                ++n2;
            }
            return visible;
        }
        return Collections.emptyList();
    }

    public static void saveVisibleCodings(List<ICoding> visible) {
        StringBuilder sb = new StringBuilder();
        for (ICoding iCoding : visible) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(iCoding.getCode());
        }
        CoreHub.mandantCfg.set(CFG_VISIBLE_CODINGS, sb.toString());
    }

    public static List<ICoding> loadSelectedCodings() {
        String selectedCodingsString = CoreHub.mandantCfg.get(CFG_SELECTED_CODINGS, null);
        if (selectedCodingsString != null) {
            String[] parts;
            ArrayList<ICoding> selected = new ArrayList<ICoding>();
            List<ICoding> availableCodings = FindingsUiUtil.getAvailableCodings();
            String[] stringArray = parts = selectedCodingsString.split("\\|");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                for (ICoding availableCoding : availableCodings) {
                    if (!availableCoding.getCode().equals(part)) continue;
                    selected.add(availableCoding);
                    break;
                }
                ++n2;
            }
            return selected;
        }
        return Collections.emptyList();
    }

    public static void saveSelectedCodings(List<ICoding> selection) {
        StringBuilder sb = new StringBuilder();
        for (ICoding iCoding : selection) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(iCoding.getCode());
        }
        CoreHub.mandantCfg.set(CFG_SELECTED_CODINGS, sb.toString());
    }

    public static void saveGroup(ICompositeSaveable iCompositeSaveable) {
        for (ICompositeSaveable child : iCompositeSaveable.getChildReferences()) {
            if (child instanceof CompositeGroup) {
                FindingsUiUtil.saveGroup(child);
                continue;
            }
            FindingsUiUtil.save(child);
        }
        for (ICompositeSaveable child : iCompositeSaveable.getChildComponents()) {
            if (child instanceof CompositeGroup) {
                FindingsUiUtil.saveGroup(child);
                continue;
            }
            FindingsUiUtil.save(child);
        }
    }

    public static void save(ICompositeSaveable iCompositeSaveable) {
        String text = iCompositeSaveable.getFieldTextValue();
        IFinding iFinding = iCompositeSaveable.getFinding();
        if (iFinding instanceof IObservation) {
            IObservation iObservation = (IObservation)iCompositeSaveable.getFinding();
            ObservationComponent obsComponent = iCompositeSaveable.getObservationComponent();
            IObservation.ObservationType observationType = iCompositeSaveable.getObservationType();
            if (IObservation.ObservationType.TEXT.equals((Object)observationType)) {
                if (obsComponent != null) {
                    obsComponent.setStringValue(text);
                } else {
                    iObservation.setStringValue(text);
                }
            } else if (IObservation.ObservationType.NUMERIC.equals((Object)observationType)) {
                try {
                    if (obsComponent != null) {
                        BigDecimal number = NumberUtils.isNumber((String)text) ? new BigDecimal(text) : null;
                        obsComponent.setNumericValue(number);
                        iObservation.updateComponent(obsComponent);
                    } else {
                        BigDecimal number = NumberUtils.isNumber((String)text) ? new BigDecimal(text) : null;
                        iObservation.setNumericValue(number, iObservation.getNumericValueUnit().orElse(""));
                    }
                }
                catch (NumberFormatException e) {
                    LoggerFactory.getLogger(FindingsUiUtil.class).warn("cannot save number illegal format", (Throwable)e);
                }
            }
        }
    }

    private static Optional<String> getComment(ICompositeSaveable iCompositeSaveable, boolean wrap, boolean emptyAllowed) {
        for (Action a : iCompositeSaveable.getToolbarActions()) {
            String comment;
            if (!(a instanceof CommentAction) || (comment = ((CommentAction)a).getComment()) == null || !emptyAllowed && StringUtils.isBlank((CharSequence)comment)) continue;
            if (wrap) {
                return Optional.of("[" + comment + "]");
            }
            return Optional.of(comment);
        }
        return Optional.empty();
    }

    public static IFinding saveObservation(IObservation iObservation, ICompositeSaveable iCompositeSaveable, LocalDateTime localDateTime) {
        FindingsUiUtil.getComment(iCompositeSaveable, false, true).ifPresent(item -> iObservation.setComment(item));
        for (ICompositeSaveable child : iCompositeSaveable.getChildReferences()) {
            child.saveContents(localDateTime);
        }
        iObservation.setEffectiveTime(localDateTime);
        return iObservation;
    }

    public static List<Action> createToolbarMainComponent(Composite c, IObservation iObservation, int horizontalGrap) {
        Composite toolbarComposite = new Composite(c, 0);
        toolbarComposite.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)2));
        toolbarComposite.setLayoutData((Object)new GridData(131072, 128, true, false));
        ArrayList<Action> actions = new ArrayList<Action>();
        LocalDateTime currentDate = iObservation.getEffectiveTime().orElse(LocalDateTime.now());
        ToolBarManager menuManager = new ToolBarManager(0x800100);
        DateAction action = new DateAction(c.getShell(), currentDate, toolbarComposite);
        menuManager.add((IAction)action);
        menuManager.createControl(toolbarComposite).setLayoutData((Object)new GridData(131072, 128, false, false, horizontalGrap, 1));
        actions.add(action);
        return actions;
    }

    public static List<Action> createToolbarSubComponents(Composite c, IObservation iObservation, int horizontalGrap) {
        ArrayList<Action> actions = new ArrayList<Action>();
        String comment = iObservation.getComment().orElse("");
        ToolBarManager menuManager = new ToolBarManager(0x880100);
        CommentAction commentableAction = new CommentAction(c.getShell(), comment);
        menuManager.add((IAction)commentableAction);
        menuManager.createControl(c).setLayoutData((Object)new GridData(16384, 128, true, false, horizontalGrap, 1));
        actions.add((Action)commentableAction);
        return actions;
    }

    public static void deleteFinding(IFinding iFinding) throws ElexisException {
        try {
            try {
                if (CoreHub.getLocalLockService().acquireLock((IPersistentObject)iFinding).isOk()) {
                    new FindingDeleteCommand(iFinding, new ILockingProvider(){

                        public LockResponse releaseLock(Object object) {
                            return CoreHub.getLocalLockService().releaseLock((IPersistentObject)object);
                        }

                        public LockResponse acquireLock(Object object) {
                            return CoreHub.getLocalLockService().acquireLock((IPersistentObject)object);
                        }
                    }).execute();
                }
            }
            catch (ElexisException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"L\u00f6schen", (String)"Befund wurde nicht gel\u00f6scht. Der Befund ist auf einer anderen Station ge\u00f6ffnet.");
                CoreHub.getLocalLockService().releaseLock((IPersistentObject)iFinding);
            }
        }
        finally {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)iFinding);
        }
    }

    public static String getTypeAsText(IFinding iFinding) {
        if (iFinding instanceof ICondition) {
            return "Problem";
        }
        if (iFinding instanceof IClinicalImpression) {
            return "Beurteilung";
        }
        if (iFinding instanceof IObservation) {
            return "Beobachtung";
        }
        if (iFinding instanceof IProcedureRequest) {
            return "Prozedere";
        }
        return "";
    }

    public static Object executeCommand(String commandId, IFinding selection) {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(commandId);
            if (selection != null) {
                ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(commandId.concat(".selection"), (Object)new StructuredSelection((Object)selection));
            }
            ExecutionEvent ee = new ExecutionEvent(cmd, Collections.EMPTY_MAP, null, null);
            return cmd.executeWithChecks(ee);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FindingsUiUtil.class).error("cannot execute command with id: " + commandId, (Throwable)e);
            return null;
        }
    }
}

