/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ui.composites.CodingComposite;
import java.util.Optional;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodingEditDialog
extends TitleAreaDialog {
    private CodingComposite codingComposite;
    private Optional<ICoding> coding = Optional.empty();

    public CodingEditDialog(Shell parentShell) {
        super(parentShell);
    }

    public CodingEditDialog(ICoding coding, Shell parentShell) {
        super(parentShell);
        this.coding = Optional.of(coding);
    }

    public void create() {
        super.create();
        this.setTitle("Kodierung " + (this.coding.isPresent() ? "editieren" : "anlegen") + ".");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new FillLayout());
        this.codingComposite = new CodingComposite(ret, 0);
        this.coding.ifPresent(c -> this.codingComposite.setCoding((ICoding)c));
        return ret;
    }

    protected void okPressed() {
        this.coding = this.codingComposite.getCoding();
        super.okPressed();
    }

    public Optional<ICoding> getCoding() {
        return this.coding;
    }
}

