/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.ui.composites.CodingListComposite;
import ch.elexis.core.findings.ui.composites.NoteListComposite;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ConditionComposite
extends Composite {
    private ICondition.ConditionCategory category;
    private Optional<ICondition> condition;
    private WritableValue transientConditionValue;
    private ComboViewer statusViewer;
    private TabFolder textOrCodingFolder;
    private Text startTxt;
    private Text endTxt;
    private Text textTxt;
    private CodingListComposite codingComposite;
    private NoteListComposite notesComposite;

    public ConditionComposite(ICondition.ConditionCategory category, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.category = category;
        this.condition = Optional.empty();
        this.statusViewer = new ComboViewer((Composite)this);
        this.statusViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.statusViewer.setInput((Object)ICondition.ConditionStatus.values());
        this.statusViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICondition.ConditionStatus) {
                    return ((ICondition.ConditionStatus)element).getLocalized();
                }
                return super.getText(element);
            }
        });
        this.startTxt = new Text((Composite)this, 2048);
        this.startTxt.setLayoutData((Object)new GridData(768));
        this.startTxt.setMessage("Beginn Datum oder Beschreibung");
        this.endTxt = new Text((Composite)this, 2048);
        this.endTxt.setLayoutData((Object)new GridData(768));
        this.endTxt.setMessage("Ende Datum oder Beschreibung");
        this.textOrCodingFolder = new TabFolder((Composite)this, 0);
        TabItem textItem = new TabItem(this.textOrCodingFolder, 0, 0);
        textItem.setText("Text");
        this.textTxt = new Text((Composite)this.textOrCodingFolder, 2626);
        textItem.setControl((Control)this.textTxt);
        TabItem codingItem = new TabItem(this.textOrCodingFolder, 0, 1);
        codingItem.setText("Kodierung");
        this.codingComposite = new CodingListComposite((Composite)this.textOrCodingFolder, 0);
        this.codingComposite.setLayoutData(new GridData(768));
        codingItem.setControl((Control)this.codingComposite);
        GridData folderGd = new GridData(1808);
        this.textOrCodingFolder.setLayoutData((Object)folderGd);
        this.notesComposite = new NoteListComposite(this, 0);
        this.notesComposite.showTitle(true);
        this.notesComposite.setLayoutData(new GridData(768));
        this.initDataBinding();
    }

    private void initDataBinding() {
        this.transientConditionValue = new WritableValue();
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue targetObservable = ViewersObservables.observeSingleSelection((Viewer)this.statusViewer);
        IObservableValue modelObservable = PojoObservables.observeDetailValue((IObservableValue)this.transientConditionValue, (String)"status", TransientCondition.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.startTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue((IObservableValue)this.transientConditionValue, (String)"start", TransientCondition.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.endTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue((IObservableValue)this.transientConditionValue, (String)"end", TransientCondition.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        targetObservable = SWTObservables.observeText((Control)this.textTxt, (int)24);
        modelObservable = PojoObservables.observeDetailValue((IObservableValue)this.transientConditionValue, (String)"text", TransientCondition.class);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        this.setCondition(null);
    }

    public Optional<ICondition> getCondition() {
        return this.condition;
    }

    public void setCondition(ICondition condition) {
        this.condition = Optional.ofNullable(condition);
        if (this.condition.isPresent()) {
            this.transientConditionValue.setValue((Object)TransientCondition.fromCondition(this.condition.get()));
            List coding = this.condition.get().getCoding();
            if (coding != null && !coding.isEmpty()) {
                this.textOrCodingFolder.setSelection(1);
            }
        } else {
            TransientCondition emptyCondition = new TransientCondition();
            emptyCondition.setStatus(ICondition.ConditionStatus.ACTIVE);
            emptyCondition.setDateRecorded(LocalDate.now());
            this.transientConditionValue.setValue((Object)emptyCondition);
        }
        this.notesComposite.setInput(new NoteListComposite.NotesAdapter(){

            @Override
            public void removeNote(String note) {
                if (ConditionComposite.this.transientConditionValue.getValue() != null) {
                    ((TransientCondition)ConditionComposite.this.transientConditionValue.getValue()).removeNote(note);
                }
            }

            @Override
            public List<String> getNotes() {
                if (ConditionComposite.this.transientConditionValue.getValue() != null) {
                    return ((TransientCondition)ConditionComposite.this.transientConditionValue.getValue()).getNotes();
                }
                return Collections.emptyList();
            }

            @Override
            public void addNote(String note) {
                if (ConditionComposite.this.transientConditionValue.getValue() != null) {
                    ((TransientCondition)ConditionComposite.this.transientConditionValue.getValue()).addNote(note);
                }
            }
        });
        this.codingComposite.setInput(new CodingListComposite.CodingAdapter(){

            @Override
            public List<ICoding> getCoding() {
                if (ConditionComposite.this.transientConditionValue.getValue() != null) {
                    return ((TransientCondition)ConditionComposite.this.transientConditionValue.getValue()).getCoding();
                }
                return Collections.emptyList();
            }

            @Override
            public void setCoding(List<ICoding> coding) {
                if (ConditionComposite.this.transientConditionValue.getValue() != null) {
                    ((TransientCondition)ConditionComposite.this.transientConditionValue.getValue()).setCoding(coding);
                }
            }
        });
    }

    public void udpateModel() {
        if (!this.condition.isPresent()) {
            this.condition = Optional.of((ICondition)FindingsServiceComponent.getService().create(ICondition.class));
            this.condition.get().setCategory(this.category);
        }
        if (this.transientConditionValue.getValue() instanceof TransientCondition) {
            ((TransientCondition)this.transientConditionValue.getValue()).toCondition(this.condition.get());
        }
    }

    private static class TransientCondition {
        private String text;
        private List<ICoding> coding = new ArrayList<ICoding>();
        private ICondition.ConditionStatus status;
        private LocalDate dateRecorded;
        private List<String> notes = new ArrayList<String>();
        private String start;
        private String end;

        private TransientCondition() {
        }

        public List<ICoding> getCoding() {
            return this.coding;
        }

        public void setCoding(List<ICoding> coding) {
            this.coding = coding;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public ICondition.ConditionStatus getStatus() {
            return this.status;
        }

        public void setStatus(ICondition.ConditionStatus status) {
            this.status = status;
        }

        public void setDateRecorded(LocalDate dateRecorded) {
            this.dateRecorded = dateRecorded;
        }

        public LocalDate getDateRecorded() {
            return this.dateRecorded;
        }

        private void setNotes(List<String> notes) {
            this.notes = notes;
        }

        public List<String> getNotes() {
            return this.notes;
        }

        public void addNote(String note) {
            this.notes.add(note);
        }

        public void removeNote(String note) {
            this.notes.remove(note);
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public static TransientCondition fromCondition(ICondition condition) {
            TransientCondition ret = new TransientCondition();
            ret.setStatus(condition.getStatus());
            ret.setCoding(condition.getCoding());
            condition.getDateRecorded().ifPresent(d -> ret.setDateRecorded((LocalDate)d));
            condition.getText().ifPresent(t -> ret.setText((String)t));
            ret.setNotes(new ArrayList<String>(condition.getNotes()));
            condition.getStart().ifPresent(string -> ret.setStart((String)string));
            condition.getEnd().ifPresent(string -> ret.setEnd((String)string));
            return ret;
        }

        public void toCondition(ICondition condition) {
            condition.setStatus(this.getStatus());
            condition.setCoding(this.getCoding());
            if (this.dateRecorded != null) {
                condition.setDateRecorded(this.getDateRecorded());
            }
            if (this.text != null) {
                condition.setText(this.getText());
            }
            if (this.start != null) {
                condition.setStart(this.start);
            }
            if (this.end != null) {
                condition.setEnd(this.end);
            }
            if (this.notes != null) {
                List existingNotes = condition.getNotes();
                for (String string : existingNotes) {
                    if (this.notes.contains(string)) continue;
                    condition.removeNote(string);
                }
                for (String string : this.notes) {
                    if (existingNotes.contains(string)) continue;
                    condition.addNote(string);
                }
            }
        }
    }
}

