/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    NUMERIC(1, "NUMERIC", "NUMERIC"),
    TEXT(100, "TEXT", "TEXT"),
    GROUP(200, "GROUP", "GROUP"),
    GROUP_COMPONENT(300, "GROUP_COMPONENT", "GROUP_COMPONENT");

    public static final int NUMERIC_VALUE = 1;
    public static final int TEXT_VALUE = 100;
    public static final int GROUP_VALUE = 200;
    public static final int GROUP_COMPONENT_VALUE = 300;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{NUMERIC, TEXT, GROUP, GROUP_COMPONENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 1: {
                return NUMERIC;
            }
            case 100: {
                return TEXT;
            }
            case 200: {
                return GROUP;
            }
            case 300: {
                return GROUP_COMPONENT;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

