/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.dataaccess;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.templates.model.FindingsTemplate;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.model.InputDataGroup;
import ch.elexis.core.findings.templates.model.InputDataGroupComponent;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.slf4j.LoggerFactory;

public class FindingDataAccessor
implements IDataAccess {
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String ALL = "all";
    private static final String PREFIX_FIRST = "[Befunde-Neu:Patient:first:";
    private static final String PREFIX_LAST = "[Befunde-Neu:Patient:last:";
    private static final String PREFIX_ALL = "[Befunde-Neu:Patient:all:";
    private static final String SUFFIX = "]";

    private IDataAccess.Element createElement(String readableName, String placeholder) {
        return new IDataAccess.Element(IDataAccess.TYPE.STRING, readableName, placeholder, Patient.class, 1);
    }

    public String getName() {
        return "Befunde-Neu";
    }

    public String getDescription() {
        return "Befunde-Neu";
    }

    public List<IDataAccess.Element> getList() {
        if (FindingsServiceHolder.findingsTemplateService != null) {
            FindingsTemplates findingsTemplates = FindingsServiceHolder.findingsTemplateService.getFindingsTemplates("Standard Vorlagen");
            ArrayList<String> parameters = new ArrayList<String>();
            EList findingsTemplates2 = findingsTemplates.getFindingsTemplates();
            ECollections.sort((EList)findingsTemplates2, (Comparator)new Comparator<FindingsTemplate>(){

                @Override
                public int compare(FindingsTemplate o1, FindingsTemplate o2) {
                    if (o1 == null || o2 == null) {
                        return o1 != null ? 1 : -1;
                    }
                    return StringUtils.lowerCase((String)o1.getTitle()).compareTo(StringUtils.lowerCase((String)o2.getTitle()));
                }
            });
            for (FindingsTemplate findingTemplate : findingsTemplates2) {
                if (!(findingTemplate.getInputData() instanceof InputDataGroupComponent) && !(findingTemplate.getInputData() instanceof InputDataGroup)) continue;
                parameters.add(findingTemplate.getTitle());
            }
            ArrayList<IDataAccess.Element> ret = new ArrayList<IDataAccess.Element>(parameters.size());
            for (String n : parameters) {
                String placeholder = PREFIX_FIRST + n + SUFFIX;
                String readableName = String.valueOf(n) + " - " + "Erster";
                ret.add(this.createElement(readableName, placeholder));
                placeholder = PREFIX_LAST + n + SUFFIX;
                readableName = String.valueOf(n) + " - " + "Letzter";
                ret.add(this.createElement(readableName, placeholder));
                placeholder = PREFIX_ALL + n + SUFFIX;
                readableName = String.valueOf(n) + " - " + "Alle";
                ret.add(this.createElement(readableName, placeholder));
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String key, String[] params) {
        Result ret = null;
        if (!(dependentObject instanceof Patient)) {
            ret = new Result(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Parameter", (Object)dependentObject, true);
        } else {
            Patient pat;
            PreparedStatement preparedStatement;
            DBConnection dbConnection;
            block17: {
                Result result;
                block18: {
                    dbConnection = null;
                    preparedStatement = null;
                    pat = (Patient)dependentObject;
                    if (ALL.equals(key) || FIRST.equals(key) || LAST.equals(key)) break block17;
                    result = new Result(Result.SEVERITY.ERROR, 2, "Fehler beim Parsen der Befund-Daten. Prefix " + key + " nicht bekannt.", (Object)params, true);
                    if (dbConnection == null || preparedStatement == null) break block18;
                    dbConnection.releasePreparedStatement(preparedStatement);
                }
                return result;
            }
            try {
                try {
                    IObservation iObservation2;
                    dbConnection = PersistentObject.getDefaultConnection();
                    preparedStatement = dbConnection.getPreparedStatement("select id from CH_ELEXIS_CORE_FINDINGS_OBSERVATION where deleted = '0' and referenced = '0' and patientId = ? and content like ? and content like ?");
                    preparedStatement.setString(1, pat.getId());
                    preparedStatement.setString(2, "%\"code\":\"" + descriptor + "\"%");
                    preparedStatement.setString(3, "%\"system\":\"www.elexis.info/coding/local\"%");
                    ResultSet res = preparedStatement.executeQuery();
                    ArrayList<IObservation> observations = new ArrayList<IObservation>();
                    while (res != null && res.next()) {
                        String observationId = res.getString(1);
                        iObservation2 = FindingsServiceHolder.findingsService.findById(observationId, IObservation.class).orElse(null);
                        if (iObservation2 == null) continue;
                        observations.add(iObservation2);
                    }
                    Collections.sort(observations, new Comparator<IObservation>(){

                        @Override
                        public int compare(IObservation o1, IObservation o2) {
                            Optional d1 = o1.getEffectiveTime();
                            Optional d2 = o2.getEffectiveTime();
                            if (d1.isPresent() && d2.isPresent()) {
                                return ((LocalDateTime)d1.get()).isAfter((ChronoLocalDateTime)d2.get()) ? 1 : (((LocalDateTime)d1.get()).equals(d2.get()) ? 0 : -1);
                            }
                            if (d1.isPresent()) {
                                return 1;
                            }
                            if (d2.isPresent()) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    StringBuilder textBuilder = new StringBuilder();
                    if (!observations.isEmpty()) {
                        if (FIRST.equals(key)) {
                            iObservation2 = (IObservation)observations.get(0);
                            observations.clear();
                            observations.add(iObservation2);
                        } else if (LAST.equals(key)) {
                            iObservation2 = (IObservation)observations.get(observations.size() - 1);
                            observations.clear();
                            observations.add(iObservation2);
                        }
                        for (IObservation iObservation2 : observations) {
                            if (iObservation2 == null) continue;
                            if (textBuilder.length() > 0) {
                                textBuilder.append(System.lineSeparator());
                            }
                            iObservation2.getText().ifPresent(txt -> {
                                iObservation2.getEffectiveTime().ifPresent(date -> {
                                    textBuilder.append(new TimeTool(date).toString(1));
                                    textBuilder.append(" ");
                                });
                                textBuilder.append((String)txt);
                            });
                        }
                    }
                    ret = new Result((Object)textBuilder.toString());
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(FindingDataAccessor.class).error("parse error", (Throwable)e);
                    Result result = new Result(Result.SEVERITY.ERROR, 2, "Fehler beim Parsen der Befunde-Daten", (Object)params, true);
                    if (dbConnection != null && preparedStatement != null) {
                        dbConnection.releasePreparedStatement(preparedStatement);
                    }
                    return result;
                }
            }
            catch (Throwable throwable) {
                if (dbConnection != null && preparedStatement != null) {
                    dbConnection.releasePreparedStatement(preparedStatement);
                }
                throw throwable;
            }
            if (dbConnection != null && preparedStatement != null) {
                dbConnection.releasePreparedStatement(preparedStatement);
            }
        }
        return ret;
    }
}

