/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.composite;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.ui.dlg.CodeCreateDialog;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.ui.icons.Images;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class CodesSystemsComposite
extends Composite {
    private TableViewer tableViewer;

    public CodesSystemsComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setLayoutData(new GridData(4, 4, true, true));
    }

    public void createContens() {
        Label lblCodeSystem = new Label((Composite)this, 0);
        lblCodeSystem.setText("Code System:");
        Label lblCodeSystemText = new Label((Composite)this, 0);
        lblCodeSystemText.setText(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        Button btnAdd = new Button((Composite)this, 8);
        btnAdd.setText("Code erstellen..");
        btnAdd.setLayoutData((Object)new GridData(131072, 4, false, false, 2, 1));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeCreateDialog codeDialog = new CodeCreateDialog(CodesSystemsComposite.this.getShell());
                if (codeDialog.open() == 0) {
                    CodesSystemsComposite.this.loadTable();
                }
            }
        });
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ILocalCoding iCoding = (ILocalCoding)element;
                StringBuilder stringBuilder = new StringBuilder();
                for (ICoding mappedCoding : iCoding.getMappedCodes()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(mappedCoding.getSystem());
                    stringBuilder.append(": ");
                    stringBuilder.append(mappedCoding.getCode());
                }
                return iCoding != null ? String.valueOf(iCoding.getDisplay()) + " (" + iCoding.getCode() + ")" + (stringBuilder.length() > 0 ? " [" + stringBuilder.toString() + "]" : "") : "";
            }
        });
        this.tableViewer.getTable().setLinesVisible(false);
        this.loadTable();
        this.createContextMenu((Viewer)this.tableViewer);
    }

    private void createContextMenu(final Viewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection.getFirstElement() instanceof ICoding) {
                    CodesSystemsComposite.this.fillContextMenu(mgr, selection.toArray());
                }
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public void loadTable() {
        List codings = FindingsServiceHolder.codingService.getAvailableCodes(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        codings.sort((a, b) -> ObjectUtils.compare((Comparable)((Object)a.getDisplay()), (Comparable)((Object)b.getDisplay())));
        this.tableViewer.setInput((Object)codings);
    }

    private void fillContextMenu(IMenuManager contextMenu, final Object[] objects) {
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.add((IAction)new Action("Entfernen"){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                if (objects != null) {
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof ICoding) {
                            FindingsServiceHolder.codingService.removeLocalCoding((ICoding)o);
                        }
                        ++n2;
                    }
                    CodesSystemsComposite.this.loadTable();
                }
            }
        });
    }
}

