/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.eigendiagnosen.Messages;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;

public class Eigendiagnose
extends PersistentObject
implements IDiagnose {
    static final String VERSION = "0.1.1";
    static final String TABLENAME = "CH_ELEXIS_EIGENDIAGNOSEN";
    public static final String FLD_CODE = "Kuerzel";
    public static final String FLD_TEXT = "Text";
    public static final String FLD_COMMENT = "Kommentar";
    public static final String CODESYSTEM_CODE = "ED";
    public static final String CODESYSTEM_NAME = "Eigendiagnosen";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_EIGENDIAGNOSEN(ID  VARCHAR(25) primary key,lastupdate   BIGINT,deleted      CHAR(1) default '0',parent       VARCHAR(20),code         VARCHAR(20),title        VARCHAR(80),comment      TEXT,ExtInfo      BLOB);CREATE INDEX CH_ELEXIS_EIGENDIAGNOSEN_idx1 on CH_ELEXIS_EIGENDIAGNOSEN(parent,code);INSERT INTO CH_ELEXIS_EIGENDIAGNOSEN (ID,title) VALUES ('VERSION','0.1.1');";

    static {
        Eigendiagnose.addMapping((String)TABLENAME, (String[])new String[]{"parent", "Text=title", "Kuerzel=code", "Kommentar=comment", "ExtInfo"});
        Eigendiagnose check = Eigendiagnose.load("VERSION");
        if (check.state() < 2) {
            Eigendiagnose.initialize();
        } else {
            VersionInfo v = new VersionInfo(check.get(FLD_TEXT));
            if (v.isOlder(VERSION)) {
                Eigendiagnose.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_EIGENDIAGNOSEN ADD lastupdate BIGINT;");
                check.set(FLD_TEXT, VERSION);
            }
        }
    }

    public Eigendiagnose(String parent, String code, String text, String comment) {
        this.create(null);
        this.set(new String[]{"parent", FLD_CODE, FLD_TEXT, FLD_COMMENT}, new String[]{parent == null ? "NIL" : parent, code, text, comment});
    }

    public static void initialize() {
        Eigendiagnose.createOrModifyTable((String)createDB);
    }

    public String getLabel() {
        return String.valueOf(this.get(FLD_CODE)) + " " + this.get(FLD_TEXT);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Eigendiagnose load(String id) {
        return new Eigendiagnose(id);
    }

    protected Eigendiagnose(String id) {
        super(id);
    }

    protected Eigendiagnose() {
    }

    public String getCode() {
        return this.getId();
    }

    public String getCodeSystemCode() {
        return CODESYSTEM_CODE;
    }

    public String getCodeSystemName() {
        return Messages.Eigendiagnosen_CodeSystemName;
    }

    public String getText() {
        return this.get(FLD_TEXT);
    }

    public boolean isDragOK() {
        return !this.hasChildren();
    }

    public boolean hasChildren() {
        String theText;
        JdbcLink link = PersistentObject.getConnection();
        int numOfChildren = link.queryInt("SELECT count(*) FROM CH_ELEXIS_EIGENDIAGNOSEN WHERE deleted = '0' AND parent = " + JdbcLink.wrap((String)(theText = this.get(FLD_TEXT))));
        return numOfChildren > 0;
    }
}

